/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.keystone.handler;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.keystone.KeystoneAuthException;
import com.intel.cosbench.client.keystone.KeystoneClientException;
import com.intel.cosbench.client.keystone.KeystoneInterruptedException;
import com.intel.cosbench.client.keystone.KeystoneMapper;
import com.intel.cosbench.client.keystone.KeystoneRequest;
import com.intel.cosbench.client.keystone.KeystoneResponse;
import com.intel.cosbench.client.keystone.KeystoneServerException;
import com.intel.cosbench.client.keystone.KeystoneTimeoutException;
import com.intel.cosbench.client.keystone.handler.AuthHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class HttpAuthHandler
implements AuthHandler {
    private static final String PATH = "/tokens";
    private HttpClient client;
    private String url;
    private KeystoneMapper mapper = new KeystoneMapper();

    public HttpAuthHandler(String url, int timeout) {
        this.url = url;
        this.client = HttpClientUtil.createHttpClient((int)timeout);
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public KeystoneResponse POST(KeystoneRequest request) {
        HttpPost method = new HttpPost(String.valueOf(this.url) + PATH);
        this.prepareRequest(method, request);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
        }
        catch (SocketTimeoutException stex) {
            throw new KeystoneTimeoutException(stex);
        }
        catch (ConnectTimeoutException ctex) {
            throw new KeystoneTimeoutException(ctex);
        }
        catch (InterruptedIOException iex) {
            throw new KeystoneInterruptedException(iex);
        }
        catch (Exception ex) {
            String e = "error receiving response from the keystone";
            throw new KeystoneServerException(e, ex);
        }
        return this.parseResponse(response.getStatusLine(), response.getEntity());
    }

    private void prepareRequest(HttpPost method, KeystoneRequest request) {
        StringEntity entity = null;
        try {
            String content = this.mapper.toJson(request);
            entity = new StringEntity(content);
        }
        catch (Exception ex) {
            String e = "cannot create any http entity from the request obj";
            throw new KeystoneClientException(e, ex);
        }
        method.setEntity((HttpEntity)entity);
        method.addHeader("Content-Type", "application/json");
    }

    private KeystoneResponse parseResponse(StatusLine status, HttpEntity entity) {
        String json = null;
        int code = status.getStatusCode();
        try {
            try {
                if (code < 200 || code >= 300) {
                    throw new KeystoneAuthException();
                }
                json = EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException pe) {
                String e = "error parsing keystone response to string";
                throw new KeystoneServerException(e, pe);
            }
            catch (IOException ioe) {
                String e = "error reading response from keystone";
                throw new KeystoneServerException(e, ioe);
            }
        }
        finally {
            this.clearResponse(entity);
        }
        return this.mapper.fromJson(json, KeystoneResponse.class);
    }

    private void clearResponse(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException ioe) {
            String e = "error consuming response from keystone";
            throw new KeystoneServerException(e, ioe);
        }
    }

    @Override
    public void dispose() {
        HttpClientUtil.disposeHttpClient((HttpClient)this.client);
    }
}

