/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.keystone;

import com.intel.cosbench.client.keystone.KeystoneClientException;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class KeystoneMapper {
    private ObjectMapper mapper = new ObjectMapper();

    public KeystoneMapper() {
        this.configSerialization(this.mapper);
        this.configDeserializarion(this.mapper);
    }

    private void configSerialization(ObjectMapper mapper) {
        SerializationConfig config = mapper.copySerializationConfig();
        config.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.setSerializationConfig(config);
    }

    private void configDeserializarion(ObjectMapper mapper) {
        DeserializationConfig config = mapper.copyDeserializationConfig();
        config.disable(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setDeserializationConfig(config);
    }

    public String toJson(Object obj) {
        String json = null;
        try {
            json = this.mapper.writeValueAsString(obj);
        }
        catch (Exception ex) {
            String e = "fail to generate any json string from the given object";
            throw new KeystoneClientException(e, ex);
        }
        return json;
    }

    public <T> T fromJson(String json, Class<T> clazz) {
        Object value = null;
        try {
            value = this.mapper.readValue(json, clazz);
        }
        catch (Exception ex) {
            String e = "fail to generate any obj from the given json string";
            throw new KeystoneClientException(e, ex);
        }
        return (T)value;
    }
}

