/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.keystone;

import com.intel.cosbench.client.keystone.KeystoneRequest;
import com.intel.cosbench.client.keystone.KeystoneResponse;
import com.intel.cosbench.client.keystone.KeystoneResponseException;
import com.intel.cosbench.client.keystone.handler.AuthHandler;
import com.intel.cosbench.client.keystone.handler.HttpAuthHandler;
import com.intel.cosbench.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.HttpClient;

public class KeystoneClient {
    private Logger logger;
    private String username;
    private String password;
    private String userToken;
    private String tenantId;
    private String tenantName;
    private String region;
    private AuthHandler handler;
    private KeystoneResponse response;

    public KeystoneClient(Logger logger, HttpClient client, String url, String username, String password, String tenantName, int timeout) {
        this.logger = logger;
        this.username = username;
        this.password = password;
        this.tenantName = tenantName;
        this.handler = new HttpAuthHandler(url, timeout);
    }

    public void login() {
        this.response = null;
        KeystoneRequest request = this.initRequest();
        if (this.handler == null) {
            String e = "no handler is set in this keystone client";
            throw new IllegalStateException(e);
        }
        KeystoneResponse response = this.handler.POST(request);
        this.validateResponse(response);
        this.response = response;
    }

    private KeystoneRequest initRequest() {
        KeystoneRequest request = new KeystoneRequest();
        if (this.username != null && this.password != null) {
            request.addCredentials(this.username, this.password);
        } else if (this.userToken != null) {
            request.addUserToken(this.userToken);
        } else {
            String e = "no user info is detected in this keystone client";
            throw new IllegalStateException(e);
        }
        if (this.tenantId != null) {
            request.addTenantId(this.tenantId);
        } else if (this.tenantName != null) {
            request.addTenantName(this.tenantName);
        }
        return request;
    }

    private void validateResponse(KeystoneResponse response) {
        KeystoneResponse.AccessInfo info = response.getAccess();
        if (info == null) {
            String e = "no access info is found in the auth response";
            throw new KeystoneResponseException(e);
        }
        KeystoneResponse.AccessInfo.User user = info.getUser();
        if (user == null) {
            String e = "no user info is found in the auth response";
            throw new KeystoneResponseException(e);
        }
        KeystoneResponse.AccessInfo.Token token = info.getToken();
        if (token == null) {
            String e = "no token info is found in the auth response";
            throw new KeystoneResponseException(e);
        }
        List<KeystoneResponse.AccessInfo.ServiceInfo> catalog = info.getServiceCatalog();
        if (catalog == null) {
            String e = "no service catalog is found in the auth response";
            throw new KeystoneResponseException(e);
        }
    }

    public boolean isAuthenticated() {
        return this.response != null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username != null) {
            if (this.userToken != null) {
                String e = "cannot set username and userToken simultaneously";
                throw new IllegalStateException(e);
            }
            if (username.isEmpty()) {
                String e = "username cannot be empty";
                throw new IllegalArgumentException(e);
            }
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null) {
            if (this.userToken != null) {
                String e = "cannot set password and userToken simultaneously";
                throw new IllegalStateException(e);
            }
            if (password.isEmpty()) {
                String e = "password cannot be empty";
                throw new IllegalArgumentException(e);
            }
        }
        this.password = password;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        if (userToken != null) {
            if (this.username != null) {
                String e = "cannot set usernmae and userToken simultaneously";
                throw new IllegalStateException(e);
            }
            if (this.password != null) {
                String e = "cannot set password and userToken simultaneously";
                throw new IllegalStateException(e);
            }
            if (userToken.isEmpty()) {
                String e = "userToken cannot be empty";
                throw new IllegalArgumentException(e);
            }
        }
        this.userToken = userToken;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        if (tenantId != null) {
            if (this.tenantName != null) {
                String e = "cannot set tenant id and name simultaneously";
                throw new IllegalStateException(e);
            }
            if (tenantId.isEmpty()) {
                String e = "tenant id cannot be empty";
                throw new IllegalArgumentException(e);
            }
        }
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        if (tenantName != null) {
            if (this.tenantId != null) {
                String e = "cannot set tenant id and name simultaneously";
                throw new IllegalStateException(e);
            }
            if (tenantName.isEmpty()) {
                String e = "tenant name cannot be empty";
                throw new IllegalArgumentException(e);
            }
        }
        this.tenantName = tenantName;
    }

    public AuthHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AuthHandler handler) {
        if (handler == null) {
            String e = "authentication handler cannot be null";
            throw new IllegalArgumentException(e);
        }
        this.handler = handler;
    }

    public String getKeystoneTokenId() {
        return this.getToken().getId();
    }

    public String getServiceUrl(String serviceName, String region) {
        KeystoneResponse.AccessInfo.ServiceInfo service = this.getServiceInfo(serviceName);
        if (service == null) {
            return null;
        }
        List<KeystoneResponse.AccessInfo.ServiceInfo.Endpoint> endpoints = service.getEndpoints();
        if (endpoints == null || endpoints.size() == 0) {
            this.logger.error("no endpoints return from keystone");
            return null;
        }
        ArrayList<String> regions = new ArrayList<String>();
        for (KeystoneResponse.AccessInfo.ServiceInfo.Endpoint endpoint : endpoints) {
            String the_region = endpoint.getRegion();
            if (the_region == null) continue;
            regions.add(the_region);
        }
        if (region == null || region.isEmpty()) {
            this.logger.warn("Below regions are returned from keystone : " + ((Object)regions).toString() + ", but no expected region assigned in your configuration, so the first region will be used.");
            return endpoints.get(0).getPublicURL();
        }
        int idx = -1;
        idx = regions.indexOf(region);
        if (idx >= 0) {
            return endpoints.get(idx).getPublicURL();
        }
        return null;
    }

    public KeystoneResponse.AccessInfo.ServiceInfo getServiceInfo(String serviceName) {
        List<KeystoneResponse.AccessInfo.ServiceInfo> catalog = this.getAccessInfo().getServiceCatalog();
        for (KeystoneResponse.AccessInfo.ServiceInfo service : catalog) {
            if (!(serviceName != null ? serviceName.equals(service.getName()) : service.getName() == null)) continue;
            return service;
        }
        ArrayList<String> services = new ArrayList<String>();
        for (KeystoneResponse.AccessInfo.ServiceInfo service : catalog) {
            services.add(service.getName());
        }
        this.logger.error("no designated service [" + serviceName + "] found, but only those services returned: " + ((Object)services).toString());
        return null;
    }

    public KeystoneResponse.AccessInfo.User getUser() {
        return this.getAccessInfo().getUser();
    }

    public KeystoneResponse.AccessInfo.Token getToken() {
        return this.getAccessInfo().getToken();
    }

    private KeystoneResponse.AccessInfo getAccessInfo() {
        return this.getResponse().getAccess();
    }

    private KeystoneResponse getResponse() {
        return this.response;
    }

    public void dispose() {
        this.handler.dispose();
    }
}

