/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.keystone;

import com.intel.cosbench.api.auth.AuthBadException;
import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.auth.AuthInterruptedException;
import com.intel.cosbench.api.auth.AuthTimeoutException;
import com.intel.cosbench.api.auth.NoneAuth;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.keystone.KeystoneAuthContext;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.keystone.KeystoneAuthException;
import com.intel.cosbench.client.keystone.KeystoneClient;
import com.intel.cosbench.client.keystone.KeystoneConstants;
import com.intel.cosbench.client.keystone.KeystoneInterruptedException;
import com.intel.cosbench.client.keystone.KeystoneTimeoutException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import org.apache.http.client.HttpClient;

class KeystoneAuth
extends NoneAuth {
    private KeystoneClient client;
    private String url;
    private String username;
    private String password;
    private String userToken;
    private String tenantId;
    private String tenantName;
    private String region;
    private String service;
    private int timeout;
    Logger logger = null;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.logger = logger;
        this.url = config.get("auth_url", config.get("url", "http://127.0.0.1:5000/v2.0"));
        this.username = config.get("username", "");
        this.password = config.get("password", "");
        this.userToken = config.get("usertoken", "");
        this.tenantId = config.get("tenant_id", "");
        this.tenantName = config.get("tenant_name", config.get("tenname", ""));
        this.service = config.get("service", "swift");
        this.timeout = config.getInt("timeout", KeystoneConstants.CONN_TIMEOUT_DEFAULT.intValue());
        this.region = config.get("region", "regionOne");
        this.parms.put("auth_url", (Object)this.url);
        this.parms.put("username", (Object)this.username);
        this.parms.put("password", (Object)this.password);
        this.parms.put("usertoken", (Object)this.userToken);
        this.parms.put("tenant_id", (Object)this.tenantId);
        this.parms.put("tenant_name", (Object)this.tenantName);
        this.parms.put("service", (Object)this.service);
        this.parms.put("timeout", (Object)this.timeout);
        this.parms.put("region", (Object)"regionOne");
        logger.debug("using auth config: {}", (Object)this.parms);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new KeystoneClient(logger, httpClient, this.url, this.username, this.password, this.tenantName, this.timeout);
        logger.debug("keystone client has been initialized");
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public AuthContext login() {
        super.login();
        try {
            this.client.login();
        }
        catch (KeystoneTimeoutException te) {
            throw new AuthTimeoutException((Throwable)te);
        }
        catch (KeystoneInterruptedException ie) {
            throw new AuthInterruptedException((Throwable)ie);
        }
        catch (KeystoneAuthException ae) {
            throw new AuthBadException((Throwable)ae);
        }
        catch (Exception e) {
            throw new AuthException((Throwable)e);
        }
        return this.createContext();
    }

    private AuthContext createContext() {
        KeystoneAuthContext context = new KeystoneAuthContext(this.url, this.username, this.password, this.service, this.client.getKeystoneTokenId(), this.client.getServiceUrl(this.service, this.region));
        return context;
    }
}

