/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.swift;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

public class SwiftResponse {
    private HttpResponse response = null;
    private HttpEntity entity = null;

    public SwiftResponse(HttpResponse response) {
        this.response = response;
        this.entity = response.getEntity();
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public Header getResponseHeader(String headerName) {
        return this.response.getFirstHeader(headerName);
    }

    public Header[] getResponseHeaders() {
        return this.response.getAllHeaders();
    }

    public void consumeResposeBody() throws IOException {
        EntityUtils.consume((HttpEntity)this.entity);
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        return this.entity.getContent();
    }

    public boolean loginSuccess() {
        int statusCode = this.getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public String getAuthToken() {
        Header header = this.getResponseHeader("X-Auth-Token");
        return header != null ? header.getValue() : null;
    }

    public String getStorageURL() {
        Header header = this.getResponseHeader("X-Storage-Url");
        return header != null ? header.getValue() : null;
    }

    public long getContainerBytesUsed() {
        Header header = this.getResponseHeader("X-Container-Bytes-Used");
        return header != null ? Long.parseLong(header.getValue()) : -1L;
    }

    public int getContainerObjectCount() {
        Header header = this.getResponseHeader("X-Container-Object-Count");
        return header != null ? Integer.parseInt(header.getValue()) : -1;
    }

    public long getAccountBytesUsed() {
        Header header = this.getResponseHeader("X-Account-Bytes-Used");
        return header != null ? Long.parseLong(header.getValue()) : -1L;
    }

    public int getAccountContainerCount() {
        Header header = this.getResponseHeader("X-Account-Container-Count");
        return header != null ? Integer.parseInt(header.getValue()) : -1;
    }
}

