/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.swift;

import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.swift.SwiftAccount;
import com.intel.cosbench.client.swift.SwiftConflictException;
import com.intel.cosbench.client.swift.SwiftContainer;
import com.intel.cosbench.client.swift.SwiftException;
import com.intel.cosbench.client.swift.SwiftFileNotFoundException;
import com.intel.cosbench.client.swift.SwiftResponse;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;

public class SwiftClient {
    private static boolean REPORT_DELETE_ERROR = false;
    private String authToken;
    private String storageURL;
    private String policy;
    private int rate;
    private HttpClient client;
    private volatile HttpUriRequest method;

    public SwiftClient(HttpClient client) {
        this.client = client;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getStorageURL() {
        return this.storageURL;
    }

    public void dispose() {
        this.method = null;
        HttpClientUtil.disposeHttpClient((HttpClient)this.client);
    }

    public void abort() {
        if (this.method != null) {
            this.method.abort();
        }
        this.method = null;
    }

    public void init(String authToken, String storageURL, String policy, int rate) {
        this.authToken = authToken;
        this.storageURL = storageURL;
        this.policy = policy;
        this.rate = rate;
    }

    public SwiftAccount getAccountInfo() throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpHead((String)this.storageURL);
            this.method.setHeader("X-Auth-Token", this.authToken);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 204) {
                long bytesUsed = response.getAccountBytesUsed();
                int containerCount = response.getAccountContainerCount();
                SwiftAccount swiftAccount = new SwiftAccount(bytesUsed, containerCount);
                return swiftAccount;
            }
            throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public SwiftContainer getContainerInfo(String container) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpHead((String)this.getContainerPath(container));
            this.method.setHeader("X-Auth-Token", this.authToken);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 204) {
                long bytesUsed = response.getContainerBytesUsed();
                int objectCount = response.getContainerObjectCount();
                SwiftContainer swiftContainer = new SwiftContainer(container, bytesUsed, objectCount);
                return swiftContainer;
            }
            if (response.getStatusCode() == 404) {
                throw new SwiftFileNotFoundException("container not found: " + container, response.getResponseHeaders(), response.getStatusLine());
            }
            throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createContainer(String container) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            Logger logger = LogFactory.getSystemLogger();
            logger.debug("Creating container with auth_token " + this.authToken);
            this.method = HttpClientUtil.makeHttpPut((String)this.getContainerPath(container));
            this.method.setHeader("X-Auth-Token", this.authToken);
            if (this.policy != null) {
                this.method.setHeader("X-Storage-Policy", this.policy);
            }
            if ((response = new SwiftResponse(this.client.execute(this.method))).getStatusCode() == 201) {
                logger.debug("Creating container " + container + " SUCCESS");
                return;
            }
            if (response.getStatusCode() != 202) throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
            logger.debug("Creating container " + container + " SUCCESS");
            return;
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public void deleteContainer(String container) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpDelete((String)this.getContainerPath(container));
            this.method.setHeader("X-Auth-Token", this.authToken);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 204) {
                return;
            }
            if (response.getStatusCode() == 404) {
                throw new SwiftFileNotFoundException("container not found: " + container, response.getResponseHeaders(), response.getStatusLine());
            }
            if (response.getStatusCode() == 409) {
                throw new SwiftConflictException("cannot delete an non-empty container " + container, response.getResponseHeaders(), response.getStatusLine());
            }
            throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public InputStream getObjectAsStream(String container, String object) throws IOException, SwiftException {
        this.method = HttpClientUtil.makeHttpGet((String)this.getObjectPath(container, object));
        this.method.setHeader("X-Auth-Token", this.authToken);
        this.method.setHeader("X-Transfer-Rate", new Integer(this.rate).toString());
        SwiftResponse response = new SwiftResponse(this.client.execute(this.method));
        if (response.getStatusCode() == 200) {
            return response.getResponseBodyAsStream();
        }
        response.consumeResposeBody();
        if (response.getStatusCode() == 404) {
            throw new SwiftFileNotFoundException("object not found " + container + " / " + object, response.getResponseHeaders(), response.getStatusLine());
        }
        throw new SwiftException("unexpected result from server", response.getResponseHeaders(), response.getStatusLine());
    }

    public InputStream getTargetList(String container, String object) throws IOException, SwiftException {
        this.method = object.isEmpty() ? HttpClientUtil.makeHttpGet((String)this.getObjectPath(container, object)) : HttpClientUtil.makeHttpHead((String)this.getObjectPath(container, object));
        this.method.setHeader("X-Auth-Token", this.authToken);
        SwiftResponse response = new SwiftResponse(this.client.execute(this.method));
        if (response.getStatusCode() == 200) {
            if (!object.isEmpty() && response != null) {
                response.consumeResposeBody();
            }
            return object.isEmpty() ? response.getResponseBodyAsStream() : new ByteArrayInputStream(new byte[0]);
        }
        response.consumeResposeBody();
        if (response.getStatusCode() == 404) {
            throw new SwiftFileNotFoundException("list target not found " + container + " / " + object, response.getResponseHeaders(), response.getStatusLine());
        }
        throw new SwiftException("unexpected result from server", response.getResponseHeaders(), response.getStatusLine());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeObject(String container, String object, byte[] data) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpPut((String)this.getObjectPath(container, object));
            this.method.setHeader("X-Auth-Token", this.authToken);
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setChunked(false);
            entity.setContentType("application/octet-stream");
            ((HttpPut)this.method).setEntity((HttpEntity)entity);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 201) {
                return;
            }
            if (response.getStatusCode() == 202) {
                return;
            }
            if (response.getStatusCode() != 404) throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
            throw new SwiftFileNotFoundException("container not found", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeStreamedObject(String container, String object, InputStream data, long length) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpPut((String)this.getObjectPath(container, object));
            this.method.setHeader("X-Auth-Token", this.authToken);
            InputStreamEntity entity = new InputStreamEntity(data, length);
            if (length < 0L) {
                entity.setChunked(true);
            } else {
                entity.setChunked(false);
            }
            entity.setContentType("application/octet-stream");
            ((HttpPut)this.method).setEntity((HttpEntity)entity);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 201) {
                return;
            }
            if (response.getStatusCode() == 202) {
                return;
            }
            if (response.getStatusCode() != 404) throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
            throw new SwiftFileNotFoundException("container not found " + container + "/" + object, response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteObject(String container, String object) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpDelete((String)this.getObjectPath(container, object));
            this.method.setHeader("X-Auth-Token", this.authToken);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 204) {
                return;
            }
            if (!REPORT_DELETE_ERROR) {
                return;
            }
            if (response.getStatusCode() != 404) throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
            throw new SwiftFileNotFoundException("object not found " + container + "/" + object, response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public void storeObjectMetadata(String container, String object, Map<String, String> map) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpPost((String)this.getObjectPath(container, object));
            this.method.setHeader("X-Auth-Token", this.authToken);
            for (String ele : map.keySet()) {
                this.method.addHeader(ele, map.get(ele));
            }
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 202) {
                return;
            }
            if (response.getStatusCode() == 404) {
                throw new SwiftFileNotFoundException("object not found: " + container + "/" + object, response.getResponseHeaders(), response.getStatusLine());
            }
            throw new SwiftException("unexpected return from server", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public Map<String, String> getObjectMetadata(String container, String object) throws IOException, SwiftException {
        SwiftResponse response = null;
        try {
            this.method = HttpClientUtil.makeHttpHead((String)this.getObjectPath(container, object));
            this.method.setHeader("X-Auth-Token", this.authToken);
            response = new SwiftResponse(this.client.execute(this.method));
            if (response.getStatusCode() == 200) {
                Header[] headers = response.getResponseHeaders();
                HashMap<String, String> map = new HashMap<String, String>();
                Header[] headerArray = headers;
                int n = headers.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    map.put(header.getName(), header.getValue());
                    ++n2;
                }
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            if (response.getStatusCode() == 404) {
                throw new SwiftFileNotFoundException("object not found: " + container + "/" + object, response.getResponseHeaders(), response.getStatusLine());
            }
            throw new SwiftException("unexpected result from server", response.getResponseHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                response.consumeResposeBody();
            }
        }
    }

    public boolean containerExists(String container) throws IOException, HttpException {
        try {
            this.getContainerInfo(container);
        }
        catch (SwiftException swiftException) {
            return false;
        }
        return true;
    }

    private String getContainerPath(String container) {
        return String.valueOf(this.storageURL) + "/" + HttpClientUtil.encodeURL((String)container);
    }

    private String getObjectPath(String container, String object) {
        return String.valueOf(this.getContainerPath(container)) + "/" + HttpClientUtil.encodeURL((String)object);
    }
}

