/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.swift;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.context.DefaultAuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.api.storage.StorageTimeoutException;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.client.swift.SwiftClient;
import com.intel.cosbench.client.swift.SwiftConstants;
import com.intel.cosbench.client.swift.SwiftException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ConnectTimeoutException;

class SwiftStorage
extends NoneStorage {
    private SwiftClient client;
    private int timeout;
    private String token;
    private String storage_url;
    private String policy;
    private int transfer_rate;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.timeout = config.getInt("timeout", SwiftConstants.CONN_TIMEOUT_DEFAULT.intValue());
        this.token = config.get("token", "AUTH_xxx");
        this.storage_url = config.get("storage_url", "http://127.0.0.1:8080/auth/v1.0");
        this.policy = config.get("policy", SwiftConstants.POLICY_DEFAULT);
        this.transfer_rate = config.getInt("transfer_rate", SwiftConstants.TRANSFER_RATE_DEFAULT.intValue());
        this.parms.put("timeout", (Object)this.timeout);
        this.parms.put("token", (Object)this.token);
        this.parms.put("storage_url", (Object)this.storage_url);
        this.parms.put("policy", (Object)this.policy);
        this.parms.put("transfer_rate", (Object)this.transfer_rate);
        logger.debug("using storage config: {}", (Object)this.parms);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new SwiftClient(httpClient);
        logger.debug("swift client has been initialized");
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
        if (info != null) {
            this.token = info.getStr("token");
            this.storage_url = info.getStr("storage_url");
        }
        try {
            this.client.init(this.token, this.storage_url, this.policy, this.transfer_rate);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        this.logger.debug(new StringBuffer().append("using auth token: ").append(this.token).append(", storage url: ").append(this.storage_url).append(", storage policy: ").append(this.policy).toString());
    }

    public AuthContext getAuthContext() {
        String token = this.client.getAuthToken();
        String storage_url = this.client.getStorageURL();
        DefaultAuthContext info = new DefaultAuthContext();
        info.put("token", (Object)token);
        info.put("storage_url", (Object)storage_url);
        this.logger.debug("returned auth token: {}, storage url: {}", (Object)token, (Object)storage_url);
        return info;
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public void abort() {
        super.abort();
        this.client.abort();
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            stream = this.client.getObjectAsStream(container, object);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public InputStream getList(String container, String object, Config config) {
        InputStream stream;
        super.getList(container, object, config);
        try {
            stream = this.client.getTargetList(container, object);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            if (!this.client.containerExists(container)) {
                this.client.createContainer(container);
            }
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Deprecated
    public void createObject(String container, String object, byte[] data, Config config) {
        super.createObject(container, object, data, config);
        try {
            this.client.storeObject(container, object, data);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.storeStreamedObject(container, object, data, length);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            if (this.client.containerExists(container)) {
                this.client.deleteContainer(container);
            }
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected void createMetadata(String container, String object, Map<String, String> map, Config config) {
        super.createMetadata(container, object, map, config);
        try {
            this.client.storeObjectMetadata(container, object, map);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected Map<String, String> getMetadata(String container, String object, Config config) {
        super.getMetadata(container, object, config);
        try {
            return this.client.getObjectMetadata(container, object);
        }
        catch (SocketTimeoutException ste) {
            throw new StorageTimeoutException((Throwable)ste);
        }
        catch (ConnectTimeoutException cte) {
            throw new StorageTimeoutException((Throwable)cte);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (SwiftException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)se);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

