/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.amplistor;

import com.intel.cosbench.client.amplistor.AmpliNamespace;
import com.intel.cosbench.client.amplistor.AmpliPolicy;
import java.util.ArrayList;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class AmpliUtils {
    public static AmpliPolicy policyFromResponse(HttpResponse response) {
        AmpliPolicy newPolicy = new AmpliPolicy();
        newPolicy.id = AmpliUtils.unquotedString(response.getFirstHeader("X-Ampli-Id").getValue());
        newPolicy.spread_Width = Long.parseLong(response.getFirstHeader("X-Ampli-Spread-Width").getValue());
        newPolicy.safety = Long.parseLong(response.getFirstHeader("X-Ampli-Safety").getValue());
        newPolicy.hierarchy_Rules = AmpliUtils.unfold(response.getFirstHeader("X-Ampli-Hierarchy-Rules").getValue()).toArray();
        newPolicy.max_Superblock_Size = Long.parseLong(response.getFirstHeader("X-Ampli-Max-Superblock-Size").getValue());
        newPolicy.safety_Strategy = AmpliUtils.unfold(response.getFirstHeader("X-Ampli-Safety-Strategy").getValue()).toArray();
        newPolicy.n_Messages = Long.parseLong(response.getFirstHeader("X-Ampli-N-Messages").getValue());
        return newPolicy;
    }

    public static HttpRequest policyToRequest(HttpRequest request, AmpliPolicy policy) {
        request.setHeader("X-Ampli-Spread-Width", new Long(policy.spread_Width).toString());
        request.setHeader("X-Ampli-Safety", new Long(policy.safety).toString());
        request.setHeader("X-Ampli-Hierarchy-Rules", AmpliUtils.fold(policy.hierarchy_Rules));
        request.setHeader("X-Ampli-Max-Superblock-Size", new Long(policy.max_Superblock_Size).toString());
        request.setHeader("X-Ampli-Safety-Strategy", AmpliUtils.fold(policy.safety_Strategy));
        request.setHeader("X-Ampli-N-Messages", new Long(policy.n_Messages).toString());
        return request;
    }

    public static AmpliNamespace namespaceFromResponse(HttpResponse response) {
        AmpliNamespace newNamespace = new AmpliNamespace();
        newNamespace.name = AmpliUtils.unquotedString(response.getFirstHeader("X-Ampli-Name").getValue());
        newNamespace.policy_Id = AmpliUtils.unquotedString(response.getFirstHeader("X-Ampli-Policy-Id").getValue());
        newNamespace.master_Node_Id = Long.parseLong(response.getFirstHeader("X-Ampli-Master-Node-Id").getValue());
        return newNamespace;
    }

    public static HttpRequest namespaceToRequest(HttpRequest request, AmpliNamespace namespace) {
        request.setHeader("X-Ampli-Name", AmpliUtils.quotedString(namespace.name));
        request.setHeader("X-Ampli-Policy-Id", AmpliUtils.quotedString(namespace.policy_Id));
        request.setHeader("X-Ampli-Master-Node-Id", Long.toString(namespace.master_Node_Id));
        return request;
    }

    public static String unquotedString(String str) {
        return AmpliUtils.trim(str, "\"");
    }

    public static String quotedString(String str) {
        return "\"" + str + "\"";
    }

    public static String trim(String str, String delimiter) {
        if (str.startsWith(delimiter)) {
            str = str.substring(delimiter.length());
        }
        if (str.endsWith(delimiter)) {
            str = str.substring(0, str.length() - delimiter.length());
        }
        return str.trim();
    }

    public static String fold(Object[] al) {
        String sl = "[";
        int size = al.length;
        if (size < 1) {
            return sl;
        }
        int i = 0;
        while (i < size - 1) {
            Object obj = al[i];
            if (obj instanceof String) {
                obj = AmpliUtils.quotedString((String)obj);
            }
            sl = String.valueOf(sl) + obj + ",";
            ++i;
        }
        Object obj = al[size - 1];
        if (obj instanceof String) {
            obj = AmpliUtils.quotedString((String)obj);
        }
        sl = String.valueOf(sl) + obj + "]";
        return sl;
    }

    public static ArrayList<Object> unfold(String str) {
        ArrayList<Object> al = new ArrayList<Object>();
        str = AmpliUtils.trim(str, "[");
        str = AmpliUtils.trim(str, "]");
        String[] s = str.split(",");
        int i = 0;
        while (i < s.length) {
            String se = s[i].trim();
            if (se.equalsIgnoreCase(Boolean.TRUE.toString()) || se.equalsIgnoreCase(Boolean.FALSE.toString())) {
                al.add(Boolean.parseBoolean(se));
            } else {
                try {
                    long l = Long.parseLong(se);
                    al.add(l);
                }
                catch (NumberFormatException numberFormatException) {
                    al.add(AmpliUtils.unquotedString(se));
                }
            }
            ++i;
        }
        return al;
    }
}

