/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.amplistor;

import com.intel.cosbench.client.amplistor.AmpliException;
import com.intel.cosbench.client.amplistor.AmpliNamespace;
import com.intel.cosbench.client.amplistor.AmpliNotFoundException;
import com.intel.cosbench.client.amplistor.AmpliPolicy;
import com.intel.cosbench.client.amplistor.AmpliUtils;
import com.intel.cosbench.client.http.HttpClientUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

public class AmpliClient {
    private HttpClient client = null;
    private volatile HttpUriRequest request;
    private int port;
    private String host;
    private String nsRoot;

    public AmpliClient(HttpClient client, String host, int port, String nsRoot) {
        this.client = client;
        this.host = host;
        this.port = port;
        this.nsRoot = nsRoot;
    }

    public void dispose() {
        this.request = null;
        HttpClientUtil.disposeHttpClient((HttpClient)this.client);
    }

    public void abort() {
        if (this.request != null) {
            this.request.abort();
        }
        this.request = null;
    }

    public boolean login() throws IOException, HttpException {
        String storageUrl = "http://" + this.host + ":" + this.port;
        HttpHead method = HttpClientUtil.makeHttpHead((String)storageUrl);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        return false;
    }

    public String StoreObject(String sourceFilename, String ampliNamespace, String ampliFilename) throws IOException, HttpException, AmpliException {
        File file = new File(sourceFilename);
        HttpPut method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpPut((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)ampliNamespace) + "/" + HttpClientUtil.encodeURL((String)ampliFilename)));
            method.setEntity((HttpEntity)new FileEntity(file, "application/octet-stream"));
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 412) {
                throw new AmpliException("Etag missmatch", response.getAllHeaders(), response.getStatusLine());
            }
            if (response.getStatusLine().getStatusCode() == 411) {
                throw new AmpliException("Length miss-match", response.getAllHeaders(), response.getStatusLine());
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public String StoreStreamedObject(InputStream stream, long length, String ampliNamespace, String ampliFilename) throws IOException, HttpException, AmpliException {
        HttpPut method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpPut((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)ampliNamespace) + "/" + HttpClientUtil.encodeURL((String)ampliFilename)));
            InputStreamEntity entity = new InputStreamEntity(stream, length);
            if (length < 0L) {
                entity.setChunked(true);
            } else {
                entity.setChunked(false);
            }
            method.setEntity((HttpEntity)entity);
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 412) {
                throw new AmpliException("Etag missmatch", response.getAllHeaders(), response.getStatusLine());
            }
            if (response.getStatusLine().getStatusCode() == 411) {
                throw new AmpliException("Length miss-match", response.getAllHeaders(), response.getStatusLine());
            }
            throw new AmpliException(String.valueOf(System.currentTimeMillis()) + ": [" + Thread.currentThread().getName() + "]: " + ampliNamespace + "/" + ampliFilename + ": " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public String StoreObject(byte[] data, String ampliNamespace, String ampliFilename) throws IOException, HttpException, AmpliException {
        HttpPut method = null;
        String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
        method = HttpClientUtil.makeHttpPut((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)ampliNamespace) + "/" + HttpClientUtil.encodeURL((String)ampliFilename)));
        method.setHeader("Content-Type", "application/octet-stream");
        HttpResponse response = null;
        try {
            method.setEntity((HttpEntity)new ByteArrayEntity(data));
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 201) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = response.getFirstHeader("ETag").getValue();
                return string;
            }
            throw new AmpliException(String.valueOf(ampliNamespace) + "/" + ampliFilename + ": " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public byte[] getObject(String namespace, String objName) throws IOException, HttpException, AmpliException {
        String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
        HttpGet method = HttpClientUtil.makeHttpGet((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)namespace) + "/" + HttpClientUtil.encodeURL((String)objName)));
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new AmpliException("Namespace: " + namespace + " did not have object " + objName, response.getAllHeaders(), response.getStatusLine());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        return null;
    }

    public InputStream getObjectAsStream(String namespace, String objName) throws IOException, HttpException, AmpliException {
        String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
        HttpGet method = HttpClientUtil.makeHttpGet((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)namespace) + "/" + HttpClientUtil.encodeURL((String)objName)));
        HttpResponse response = null;
        response = this.client.execute((HttpUriRequest)method);
        if (response.getStatusLine().getStatusCode() == 200) {
            return response.getEntity().getContent();
        }
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (response.getStatusLine().getStatusCode() == 404) {
            return response.getEntity().getContent();
        }
        throw new AmpliException("unknown error when request object " + objName + "@" + namespace, response.getAllHeaders(), response.getStatusLine());
    }

    public boolean deleteObject(String ampliNamespace, String name) throws HttpException, IOException, AmpliException {
        HttpDelete method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpDelete((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)ampliNamespace) + "/" + HttpClientUtil.encodeURL((String)name)));
            method.setHeader("Content-Type", "application/octet-stream");
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 204) {
                return true;
            }
            throw new AmpliNotFoundException("Namespace " + ampliNamespace + "/" + name + " is not found", response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public AmpliPolicy createPolicy(AmpliPolicy policy) throws HttpException, IOException, AmpliException {
        HttpPut method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + "/policy";
            method = HttpClientUtil.makeHttpPut((String)storageUrl);
            method.setHeader("Content-Type", "text/plain");
            AmpliUtils.policyToRequest((HttpRequest)method, policy);
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                AmpliPolicy ampliPolicy = AmpliUtils.policyFromResponse(response);
                return ampliPolicy;
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                AmpliPolicy ampliPolicy = AmpliUtils.policyFromResponse(response);
                return ampliPolicy;
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public AmpliPolicy getPolicy(String policyId) throws HttpException, IOException, AmpliException {
        HttpGet method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + "/policy";
            method = HttpClientUtil.makeHttpGet((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)policyId)));
            method.setHeader("Content-Type", "text/plain");
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                AmpliPolicy ampliPolicy = AmpliUtils.policyFromResponse(response);
                return ampliPolicy;
            }
            if (response.getStatusLine().getStatusCode() == 400) {
                throw new AmpliNotFoundException("Policy " + policyId + " is not found", response.getAllHeaders(), response.getStatusLine());
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public AmpliNamespace createNamespace(AmpliNamespace namespace) throws HttpException, IOException, AmpliException {
        HttpPut method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = new HttpPut(storageUrl);
            method.setHeader("Content-Type", "text/plain");
            AmpliUtils.namespaceToRequest((HttpRequest)method, namespace);
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 403) {
                AmpliNamespace ampliNamespace = namespace;
                return ampliNamespace;
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                AmpliNamespace ampliNamespace = AmpliUtils.namespaceFromResponse(response);
                return ampliNamespace;
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public String createNamespace(String namespace, String policy_id) throws HttpException, IOException, AmpliException {
        HttpPut method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = new HttpPut(storageUrl);
            method.setHeader("Content-Type", "text/plain");
            method.setHeader("X-Ampli-Name", AmpliUtils.quotedString(namespace));
            method.setHeader("X-Ampli-Policy-Id", AmpliUtils.quotedString(policy_id));
            method.setHeader("X-Ampli-Master-Node-Id", Long.toString(0L));
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 403) {
                String string = namespace;
                return string;
            }
            if (response.getStatusLine().getStatusCode() == 201) {
                String string = AmpliUtils.unquotedString(response.getFirstHeader("X-Ampli-Name").getValue());
                return string;
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public AmpliNamespace getNamespace(String name) throws HttpException, IOException, AmpliException {
        HttpGet method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpGet((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)name)));
            method.setHeader("Content-Type", "text/plain");
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                AmpliNamespace ampliNamespace = AmpliUtils.namespaceFromResponse(response);
                return ampliNamespace;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new AmpliNotFoundException("Namespace " + name + " is not found", response.getAllHeaders(), response.getStatusLine());
            }
            throw new AmpliException("Unexpected Server Response: " + response.getStatusLine(), response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public boolean isNamespaceExisted(String name) throws HttpException, IOException, AmpliException {
        HttpHead method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpHead((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)name)));
            method.setHeader("Content-Type", "text/plain");
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                return true;
            }
            if (response.getStatusLine().getStatusCode() == 404) {
                throw new AmpliNotFoundException("Namespace " + name + " is not found", response.getAllHeaders(), response.getStatusLine());
            }
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        return false;
    }

    public boolean deleteNamespace(String namespace) throws HttpException, IOException, AmpliException {
        HttpDelete method = null;
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            method = HttpClientUtil.makeHttpDelete((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)namespace)));
            method.setHeader("Content-Type", "text/plain");
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 204) {
                return true;
            }
            throw new AmpliNotFoundException("Namespace " + namespace + " is not found", response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public Map<String, String> getObjectMetadata(String namespace, String objName) throws IOException, HttpException, AmpliException {
        String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
        HttpGet method = HttpClientUtil.makeHttpGet((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)namespace) + "/" + HttpClientUtil.encodeURL((String)objName) + "?meta=http"));
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                Header[] headers = response.getAllHeaders();
                HashMap<String, String> map = new HashMap<String, String>();
                Header[] headerArray = headers;
                int n = headers.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    map.put(header.getName(), header.getValue());
                    ++n2;
                }
                HashMap<String, String> hashMap = map;
                return hashMap;
            }
            throw new AmpliException("unexpected error when request object metadata " + objName + "@" + namespace, response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }

    public void storeObjectMetadata(String namespace, String objName, Map<String, String> map) throws IOException, AmpliException {
        HttpResponse response = null;
        try {
            String storageUrl = "http://" + this.host + ":" + this.port + this.nsRoot;
            HttpPost method = HttpClientUtil.makeHttpPost((String)(String.valueOf(storageUrl) + "/" + HttpClientUtil.encodeURL((String)namespace) + "/" + HttpClientUtil.encodeURL((String)objName) + "?meta=http"));
            for (String ele : map.keySet()) {
                method.addHeader(ele, map.get(ele));
            }
            response = this.client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 202) {
                return;
            }
            throw new AmpliException("unexpected return from server", response.getAllHeaders(), response.getStatusLine());
        }
        finally {
            if (response != null) {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
    }
}

