/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.amplistor;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.api.storage.StorageTimeoutException;
import com.intel.cosbench.client.amplistor.AmpliClient;
import com.intel.cosbench.client.amplistor.AmpliConstants;
import com.intel.cosbench.client.amplistor.AmpliException;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.apache.http.client.HttpClient;

public class AmpliStorage
extends NoneStorage {
    private AmpliClient client;
    private String host;
    private int port;
    private String policy_id;
    private String ns_root;
    private int timeout;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.host = config.get("host", "127.0.0.1");
        this.port = config.getInt("port", 8080);
        this.policy_id = config.get("policy", "");
        this.ns_root = config.get("nsroot", "/namespace");
        this.timeout = config.getInt("timeout", AmpliConstants.TIMEOUT_DEFAULT.intValue());
        this.parms.put("host", (Object)this.host);
        this.parms.put("port", (Object)this.port);
        this.parms.put("policy", (Object)this.policy_id);
        this.parms.put("nsroot", (Object)this.ns_root);
        this.parms.put("timeout", (Object)this.timeout);
        logger.debug("using storage config: {}", (Object)this.parms);
        HttpClient httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
        this.client = new AmpliClient(httpClient, this.host, this.port, this.ns_root);
        logger.debug("ampli client has been initialized");
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public void abort() {
        super.abort();
        this.client.abort();
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            stream = this.client.getObjectAsStream(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            this.client.createNamespace(container, this.policy_id);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Deprecated
    public void createObject(String container, String object, byte[] data, Config config) {
        super.createObject(container, object, data, config);
        try {
            this.client.StoreObject(data, container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.StoreStreamedObject(data, length, container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            this.client.deleteNamespace(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected void createMetadata(String container, String object, Map<String, String> map, Config config) {
        super.createMetadata(container, object, map, config);
        try {
            this.client.storeObjectMetadata(container, object, map);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    protected Map<String, String> getMetadata(String container, String object, Config config) {
        super.getMetadata(container, object, config);
        try {
            return this.client.getObjectMetadata(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (AmpliException ae) {
            throw new StorageException(ae.getMessage(), (Throwable)ae);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

