/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.Library;
import com.ceph.rbd.RbdException;
import com.ceph.rbd.jna.RbdImageInfo;
import com.ceph.rbd.jna.RbdSnapInfo;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RbdImage {
    private Pointer image;
    private String name;

    public RbdImage(Pointer image, String name) {
        this.image = image;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Pointer getPointer() {
        return this.image.getPointer(0L);
    }

    public RbdImageInfo stat() throws RbdException {
        RbdImageInfo info = new RbdImageInfo();
        int r = Library.rbd.rbd_stat(this.getPointer(), info, 0L);
        if (r < 0) {
            throw new RbdException("Failed to stat the RBD image", r);
        }
        return info;
    }

    public boolean isOldFormat() throws RbdException {
        IntByReference old = new IntByReference();
        int r = Library.rbd.rbd_get_old_format(this.getPointer(), old);
        if (r < 0) {
            throw new RbdException("Failed to get the RBD format", r);
        }
        return old.getValue() == 1;
    }

    public void snapCreate(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_create(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to create snapshot " + snapName, r);
        }
    }

    public void snapRemove(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_remove(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to remove snapshot " + snapName, r);
        }
    }

    public void snapProtect(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_protect(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to protect snapshot " + snapName, r);
        }
    }

    public void snapUnprotect(String snapName) throws RbdException {
        int r = Library.rbd.rbd_snap_unprotect(this.getPointer(), snapName);
        if (r < 0) {
            throw new RbdException("Failed to unprotect snapshot " + snapName, r);
        }
    }

    public boolean snapIsProtected(String snapName) throws RbdException {
        IntByReference isProtected = new IntByReference();
        int r = Library.rbd.rbd_snap_is_protected(this.getPointer(), snapName, isProtected);
        if (r < 0) {
            throw new RbdException("Failed to find out if snapshot " + snapName + " is protected", r);
        }
        return isProtected.getValue() == 1;
    }

    public List<RbdSnapInfo> snapList() throws RbdException {
        int r;
        RbdSnapInfo[] snaps;
        IntByReference numSnaps;
        block2: {
            numSnaps = new IntByReference(16);
            while (true) {
                snaps = new RbdSnapInfo[numSnaps.getValue()];
                r = Library.rbd.rbd_snap_list(this.getPointer(), snaps, numSnaps);
                if (r >= 0) break block2;
                if (r != -34) break;
                numSnaps.setValue(r);
            }
            throw new RbdException("Failed listing snapshots", r);
        }
        numSnaps.setValue(r);
        for (int i = 0; i < numSnaps.getValue(); ++i) {
            snaps[i].setAutoSynch(false);
        }
        Library.rbd.rbd_snap_list_end(snaps);
        return Arrays.asList(snaps).subList(0, numSnaps.getValue());
    }

    public void write(byte[] data, long offset, int length) throws RbdException {
        if (length < 1) {
            throw new RbdException("There should be at least one byte to write");
        }
        int r = Library.rbd.rbd_write(this.getPointer(), offset, length, data);
        if (r < 0) {
            throw new RbdException("Failed writing " + length + " bytes starting at offset " + offset, r);
        }
    }

    public void write(byte[] data, long offset) throws RbdException {
        this.write(data, offset, data.length);
    }

    public void write(byte[] data) throws RbdException {
        this.write(data, 0L, data.length);
    }

    public int read(long offset, byte[] buffer, int length) {
        return Library.rbd.rbd_read(this.getPointer(), offset, length, buffer);
    }

    public void resize(long size) throws RbdException {
        int r = Library.rbd.rbd_resize(this.getPointer(), size);
        if (r < 0) {
            throw new RbdException("Failed to resize the RBD image", r);
        }
    }

    public void flatten() throws RbdException {
        int r = Library.rbd.rbd_flatten(this.getPointer());
        if (r < 0) {
            throw new RbdException("Failed to flatten the RBD image", r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listChildren(String snapname) throws RbdException {
        long r = Library.rbd.rbd_snap_set(this.getPointer(), snapname);
        if (r < 0L) {
            throw new RbdException("Failed to set snapshot name to " + snapname + ". Return code: " + r);
        }
        try {
            int initialBufferSize = 1024;
            LongByReference poolBufferSize = new LongByReference((long)initialBufferSize);
            LongByReference imageBufferSize = new LongByReference((long)initialBufferSize);
            byte[] pools = new byte[initialBufferSize];
            byte[] images = new byte[initialBufferSize];
            r = Library.rbd.rbd_list_children(this.getPointer(), pools, poolBufferSize, images, imageBufferSize);
            if (r < 0L && r != -34L) {
                throw new RbdException("Failed to list snap children. Return code: " + r);
            }
            ArrayList<String> poolImageList = new ArrayList<String>();
            if (poolBufferSize.getValue() != 0L || imageBufferSize.getValue() != 0L) {
                String[] imageNames;
                String[] poolNames;
                if (r == -34L || poolBufferSize.getValue() > (long)initialBufferSize || imageBufferSize.getValue() > (long)initialBufferSize) {
                    pools = new byte[(int)poolBufferSize.getValue()];
                    images = new byte[(int)imageBufferSize.getValue()];
                    r = Library.rbd.rbd_list_children(this.getPointer(), pools, poolBufferSize, images, imageBufferSize);
                    if (r < 0L) {
                        throw new RbdException("Failed to list snap children. Return code: " + r);
                    }
                }
                if ((poolNames = new String(pools).split("\u0000")).length != (imageNames = new String(images).split("\u0000")).length) {
                    throw new RbdException("Mismatch between number of pools and images, pools = " + poolNames.length + ", images = " + imageNames.length);
                }
                for (int i = 0; i < poolNames.length; ++i) {
                    poolImageList.add(poolNames[i] + '/' + imageNames[i]);
                }
            }
            ArrayList<String> arrayList = poolImageList;
            return arrayList;
        }
        finally {
            Library.rbd.rbd_snap_set(this.getPointer(), new String());
        }
    }
}

