/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rbd;

import com.ceph.rbd.jna.Rbd;
import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;

final class Library {
    static final Rbd rbd = Rbd.INSTANCE;

    private Library() {
    }

    static void free(Pointer ptr) {
        Pointer.nativeValue((Pointer)ptr, (long)0L);
    }

    static String getString(Pointer ptr) {
        long len = ptr.indexOf(0L, (byte)0);
        assert (len != -1L) : "C-Strings must be \\0 terminated.";
        byte[] data = ptr.getByteArray(0L, (int)len);
        try {
            return new String(data, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Rbd problem: UTF-8 decoding error.", e);
        }
    }

    static String[] toStringArray(Pointer[] ptrArr) {
        return Library.toStringArray(ptrArr, ptrArr.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] toStringArray(Pointer[] ptrArr, int size) {
        String[] stringArray;
        try {
            String[] result = new String[size];
            for (int i = 0; i < size; ++i) {
                result[i] = Library.getString(ptrArr[i]);
            }
            stringArray = result;
        }
        catch (Throwable throwable) {
            for (int i = 0; i < size; ++i) {
                Library.free(ptrArr[i]);
                ptrArr[i] = null;
            }
            throw throwable;
        }
        for (int i = 0; i < size; ++i) {
            Library.free(ptrArr[i]);
            ptrArr[i] = null;
        }
        return stringArray;
    }
}

