/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.rados;

import com.ceph.rados.exceptions.ErrorCode;
import com.ceph.rados.exceptions.RadosAlreadyConnectedException;
import com.ceph.rados.exceptions.RadosArgumentOutOfDomainException;
import com.ceph.rados.exceptions.RadosException;
import com.ceph.rados.exceptions.RadosInvalidArgumentException;
import com.ceph.rados.exceptions.RadosNotFoundException;
import com.ceph.rados.exceptions.RadosOperationInProgressException;
import com.ceph.rados.exceptions.RadosPermissionException;
import com.ceph.rados.exceptions.RadosReadOnlyException;
import com.ceph.rados.exceptions.RadosTimeoutException;
import java.util.concurrent.Callable;

public class RadosBase {
    protected final <T extends Number> T handleReturnCode(Callable<T> callable, String errorMsg, Object ... errorMsgArgs) throws RadosException {
        Number result = (Number)this.call(callable);
        if (result.intValue() < 0) {
            this.throwException(result.intValue(), String.format(errorMsg, errorMsgArgs));
        }
        return (T)result;
    }

    private <T> T call(Callable<T> callable) throws RadosException {
        T result;
        try {
            result = callable.call();
        }
        catch (Exception ex) {
            String unknownErrorMsg = String.format("Unknown exception: %s: %s", ex.getClass().getSimpleName(), ex.getMessage());
            throw new RadosException(unknownErrorMsg, ex);
        }
        return result;
    }

    private void throwException(int errorCode, String msg) throws RadosException {
        String errorName = ErrorCode.getErrorName(errorCode);
        String errorMessage = ErrorCode.getErrorMessage(errorCode);
        String finalMessage = String.format("%s; %s: %s", msg, errorName, errorMessage);
        ErrorCode errorCodeEnum = ErrorCode.getEnum(errorCode);
        switch (errorCodeEnum) {
            case EPERM: {
                throw new RadosPermissionException(finalMessage, errorCode);
            }
            case ENOENT: {
                throw new RadosNotFoundException(finalMessage, errorCode);
            }
            case EINVAL: {
                throw new RadosInvalidArgumentException(finalMessage, errorCode);
            }
            case EROFS: {
                throw new RadosReadOnlyException(finalMessage, errorCode);
            }
            case EDOM: {
                throw new RadosArgumentOutOfDomainException(finalMessage, errorCode);
            }
            case EISCONN: {
                throw new RadosAlreadyConnectedException(finalMessage, errorCode);
            }
            case ETIMEDOUT: {
                throw new RadosTimeoutException(finalMessage, errorCode);
            }
            case EINPROGRESS: {
                throw new RadosOperationInProgressException(finalMessage, errorCode);
            }
        }
        throw new RadosException(finalMessage, errorCode);
    }
}

