/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.exporter.support.internal.support;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.osgi.service.exporter.support.internal.support.ListenerNotifier;
import org.springframework.osgi.service.exporter.support.internal.support.ServiceRegistrationDecorator;
import org.springframework.osgi.service.exporter.support.internal.support.UnregistrationNotifier;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyTargetResolver
implements UnregistrationNotifier {
    private final BeanFactory beanFactory;
    private final String beanName;
    private final boolean cacheService;
    private volatile Object target;
    private final Object lock = new Object();
    private final AtomicBoolean activated;
    private final ListenerNotifier notifier;
    private volatile ServiceRegistrationDecorator decorator;

    public LazyTargetResolver(Object target, BeanFactory beanFactory, String beanName, boolean cacheService, ListenerNotifier notifier, boolean lazyListeners) {
        this.target = target;
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.cacheService = cacheService;
        this.notifier = notifier;
        this.activated = new AtomicBoolean(!lazyListeners);
    }

    public void activate() {
        if (this.activated.compareAndSet(false, true)) {
            if (this.decorator == null) {
                this.notifier.callUnregister(null, null);
            } else {
                Object target = this.getBeanIfPossible();
                Map properties = (Map)((Object)OsgiServiceReferenceUtils.getServicePropertiesSnapshot(this.decorator.getReference()));
                this.notifier.callRegister(target, properties);
            }
        }
    }

    private Object getBeanIfPossible() {
        if (this.target == null && (this.cacheService || this.beanFactory.isSingleton(this.beanName))) {
            this.getBean();
        }
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBean() {
        if (this.target == null) {
            if (this.cacheService) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.target == null) {
                        this.target = this.beanFactory.getBean(this.beanName);
                    }
                }
            } else {
                return this.beanFactory.getBean(this.beanName);
            }
        }
        return this.target;
    }

    public Class<?> getType() {
        return this.target == null ? (this.beanFactory.isSingleton(this.beanName) ? this.beanFactory.getBean(this.beanName).getClass() : this.beanFactory.getType(this.beanName)) : this.target.getClass();
    }

    @Override
    public void unregister(Map properties) {
        if (this.activated.get()) {
            Object target = this.getBeanIfPossible();
            this.notifier.callUnregister(target, properties);
        }
    }

    public void setDecorator(ServiceRegistrationDecorator decorator) {
        this.decorator = decorator;
        if (decorator != null) {
            decorator.setNotifier(this);
        }
    }

    public void notifyIfPossible() {
        if (this.activated.get() && this.notifier != null) {
            Object target = this.getBeanIfPossible();
            Map properties = (Map)((Object)OsgiServiceReferenceUtils.getServicePropertiesSnapshot(this.decorator.getReference()));
            this.notifier.callRegister(target, properties);
        }
    }

    public void startupUnregisterIfPossible() {
        if (this.activated.get() && this.notifier != null) {
            this.notifier.callUnregister(null, null);
        }
    }
}

