/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config.internal;

import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.osgi.config.internal.AbstractReferenceDefinitionParser;
import org.springframework.osgi.config.internal.OsgiDefaultsDefinition;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class ReferenceBeanDefinitionParser
extends AbstractReferenceDefinitionParser {
    private static final String TIMEOUT_PROP = "timeout";
    protected static final String TIMEOUT = "timeout";

    protected Class getBeanClass(Element element) {
        return OsgiServiceProxyFactoryBean.class;
    }

    protected void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks, OsgiDefaultsDefinition defaults) {
        TimeoutAttributeCallback timeoutCallback = new TimeoutAttributeCallback();
        super.parseAttributes(element, builder, ParserUtils.mergeCallbacks(callbacks, new AttributeCallback[]{timeoutCallback}), defaults);
        if (!timeoutCallback.isTimeoutSpecified) {
            this.applyDefaultTimeout(builder, defaults);
        }
    }

    protected void applyDefaultTimeout(BeanDefinitionBuilder builder, OsgiDefaultsDefinition defaults) {
        builder.addPropertyValue("timeout", (Object)new TypedStringValue(defaults.getTimeout()));
    }

    static class TimeoutAttributeCallback
    implements AttributeCallback {
        boolean isTimeoutSpecified = false;

        TimeoutAttributeCallback() {
        }

        public boolean process(Element parent, Attr attribute, BeanDefinitionBuilder builder) {
            String name = attribute.getLocalName();
            if ("timeout".equals(name)) {
                this.isTimeoutSpecified = true;
            }
            return true;
        }
    }
}

