/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal.cm;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.osgi.compendium.internal.cm.BeanManagedUpdate;
import org.springframework.osgi.compendium.internal.cm.ContainerManagedUpdate;
import org.springframework.osgi.compendium.internal.cm.UpdateCallback;
import org.springframework.osgi.compendium.internal.cm.UpdateStrategy;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMUtils {
    public static void applyMapOntoInstance(Object instance, Map<String, ?> properties, AbstractBeanFactory beanFactory) {
        if (properties != null && !properties.isEmpty()) {
            BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)instance);
            if (beanFactory != null) {
                beanFactory.copyRegisteredEditorsTo((PropertyEditorRegistry)beanWrapper);
            }
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                String propertyName = entry.getKey();
                if (!beanWrapper.isWritableProperty(propertyName)) continue;
                beanWrapper.setPropertyValue(propertyName, entry.getValue());
            }
        }
    }

    public static void bulkUpdate(UpdateCallback callback, Collection<?> instances, Map<?, ?> properties) {
        for (Object instance : instances) {
            callback.update(instance, properties);
        }
    }

    public static UpdateCallback createCallback(UpdateStrategy strategy, String methodName, BeanFactory beanFactory) {
        if (UpdateStrategy.BEAN_MANAGED.equals((Object)strategy)) {
            Assert.hasText((String)methodName, (String)"method name required when using 'bean-managed' strategy");
            return new BeanManagedUpdate(methodName);
        }
        if (UpdateStrategy.CONTAINER_MANAGED.equals((Object)strategy)) {
            return new ContainerManagedUpdate(beanFactory);
        }
        return null;
    }

    public static Map getConfiguration(BundleContext bundleContext, String pid) throws IOException {
        ConfigurationAdmin cm;
        ServiceReference ref = bundleContext.getServiceReference(ConfigurationAdmin.class.getName());
        if (ref != null && (cm = (ConfigurationAdmin)bundleContext.getService(ref)) != null) {
            return new MapBasedDictionary(cm.getConfiguration(pid).getProperties());
        }
        return Collections.EMPTY_MAP;
    }

    public static ServiceRegistration registerManagedService(BundleContext bundleContext, ManagedService listener, String pid) {
        Properties props = new Properties();
        props.put("service.pid", pid);
        Bundle bundle = bundleContext.getBundle();
        props.put("Bundle-SymbolicName", OsgiStringUtils.nullSafeSymbolicName(bundle));
        props.put("Bundle-Version", OsgiBundleUtils.getBundleVersion(bundle));
        return bundleContext.registerService(ManagedService.class.getName(), (Object)listener, (Dictionary)props);
    }
}

