/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.cm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.compendium.internal.cm.CMUtils;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.service.exporter.support.ServicePropertiesChangeEvent;
import org.springframework.osgi.service.exporter.support.ServicePropertiesChangeListener;
import org.springframework.osgi.service.exporter.support.ServicePropertiesListenerManager;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigAdminPropertiesFactoryBean
implements BundleContextAware,
InitializingBean,
DisposableBean,
FactoryBean<Properties> {
    private static final Log log = LogFactory.getLog(ConfigAdminPropertiesFactoryBean.class);
    private volatile String persistentId;
    private volatile Properties properties;
    private BundleContext bundleContext;
    private boolean localOverride = false;
    private Properties localProperties;
    private volatile boolean dynamic = false;
    private volatile ServiceRegistration registration;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.persistentId, (String)"persistentId property is required");
        Assert.notNull((Object)this.bundleContext, (String)"bundleContext property is required");
        if (this.dynamic) {
            this.properties = new ChangeableProperties();
            try {
                this.initProperties(this.properties, CMUtils.getConfiguration(this.bundleContext, this.persistentId));
            }
            catch (IOException ioe) {
                throw new BeanInitializationException("Cannot retrieve configuration for pid=" + this.persistentId, (Throwable)ioe);
            }
            this.registration = CMUtils.registerManagedService(this.bundleContext, new ConfigurationWatcher(), this.persistentId);
        }
    }

    public void destroy() throws Exception {
        OsgiServiceUtils.unregisterService(this.registration);
        this.registration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties initProperties(Properties target, Map<?, ?> cmConfig) {
        Properties properties = target;
        synchronized (properties) {
            target.clear();
            if (this.localProperties != null && !this.localOverride) {
                CollectionUtils.mergePropertiesIntoMap((Properties)this.localProperties, (Map)target);
            }
            target.putAll(cmConfig);
            if (this.localProperties != null && this.localOverride) {
                CollectionUtils.mergePropertiesIntoMap((Properties)this.localProperties, (Map)target);
            }
            return target;
        }
    }

    public Properties getObject() throws Exception {
        if (this.properties == null) {
            try {
                this.properties = this.initProperties(new Properties(), CMUtils.getConfiguration(this.bundleContext, this.persistentId));
            }
            catch (IOException ioe) {
                throw new BeanInitializationException("Cannot retrieve configuration for pid=" + this.persistentId, (Throwable)ioe);
            }
        }
        return this.properties;
    }

    public Class<? extends Properties> getObjectType() {
        return this.dynamic ? ChangeableProperties.class : Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public void setProperties(Properties properties) {
        this.localProperties = properties;
    }

    public void setLocalOverride(boolean localOverride) {
        this.localOverride = localOverride;
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    private class ChangeableProperties
    extends Properties
    implements ServicePropertiesListenerManager {
        private List<ServicePropertiesChangeListener> listeners = Collections.synchronizedList(new ArrayList(4));

        private ChangeableProperties() {
        }

        public void addListener(ServicePropertiesChangeListener listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        public void removeListener(ServicePropertiesChangeListener listener) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notifyListeners() {
            ServicePropertiesChangeEvent event = new ServicePropertiesChangeEvent(this);
            List<ServicePropertiesChangeListener> list = this.listeners;
            synchronized (list) {
                for (ServicePropertiesChangeListener listener : this.listeners) {
                    listener.propertiesChange(event);
                }
            }
        }
    }

    private class ConfigurationWatcher
    implements ManagedService {
        private ConfigurationWatcher() {
        }

        public void updated(Dictionary props) throws ConfigurationException {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Configuration [" + ConfigAdminPropertiesFactoryBean.this.persistentId + "] has been updated with properties " + props));
            }
            ConfigAdminPropertiesFactoryBean.this.initProperties(ConfigAdminPropertiesFactoryBean.this.properties, new MapBasedDictionary(props));
            ((ChangeableProperties)ConfigAdminPropertiesFactoryBean.this.properties).notifyListeners();
        }
    }
}

