/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.blueprint.config.internal;

import java.util.Set;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.osgi.blueprint.config.internal.BlueprintDefaultsDefinition;
import org.springframework.osgi.blueprint.config.internal.BlueprintParser;
import org.springframework.osgi.blueprint.config.internal.BlueprintReferenceAttributeCallback;
import org.springframework.osgi.config.internal.CollectionBeanDefinitionParser;
import org.springframework.osgi.config.internal.OsgiDefaultsDefinition;
import org.springframework.osgi.config.internal.util.AttributeCallback;
import org.springframework.osgi.config.internal.util.ParserUtils;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BlueprintCollectionBeanDefinitionParser
extends CollectionBeanDefinitionParser {
    private static final String REFERENCE_LISTENER = "reference-listener";

    protected OsgiDefaultsDefinition resolveDefaults(Document document, ParserContext parserContext) {
        return new BlueprintDefaultsDefinition(document, parserContext);
    }

    protected void parseAttributes(Element element, BeanDefinitionBuilder builder, AttributeCallback[] callbacks, OsgiDefaultsDefinition defaults) {
        BlueprintReferenceAttributeCallback blueprintCallback = new BlueprintReferenceAttributeCallback();
        super.parseAttributes(element, builder, ParserUtils.mergeCallbacks(new AttributeCallback[]{blueprintCallback}, callbacks), defaults);
    }

    protected Set parsePropertySetElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertySetElement(context, beanDef, beanDefinition);
    }

    protected Object parsePropertySubElement(ParserContext context, Element beanDef, BeanDefinition beanDefinition) {
        return BlueprintParser.parsePropertySubElement(context, beanDef, beanDefinition);
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        super.doParse(element, context, builder);
        builder.addPropertyValue("useBlueprintExceptions", (Object)true);
        builder.addPropertyValue("blueprintCompliant", (Object)true);
    }

    protected String getListenerElementName() {
        return REFERENCE_LISTENER;
    }

    protected CollectionType collectionType() {
        return null;
    }

    protected String generateBeanName(String id, BeanDefinition def, ParserContext parserContext) {
        return super.generateBeanName("." + id, def, parserContext);
    }

    protected void postProcessListenerDefinition(BeanDefinition wrapperDef) {
        wrapperDef.getPropertyValues().addPropertyValue("blueprintCompliant", (Object)true);
    }

    protected void applyDefaults(ParserContext parserContext, OsgiDefaultsDefinition defaults, BeanDefinitionBuilder builder) {
        BlueprintDefaultsDefinition defs;
        super.applyDefaults(parserContext, defaults, builder);
        if (defaults instanceof BlueprintDefaultsDefinition && (defs = (BlueprintDefaultsDefinition)defaults).getDefaultInitialization()) {
            builder.setLazyInit(defs.getDefaultInitialization());
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            id = this.generateBeanName("", (BeanDefinition)definition, parserContext);
        }
        return id;
    }
}

