/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.web;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.web.AbstractController;
import com.intel.cosbench.web.BadRequestException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.servlet.ModelAndView;

public class MissionSubmissionController
extends AbstractController {
    private DriverService driver;

    public void setDriver(DriverService driver) {
        this.driver = driver;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String id = null;
        try {
            InputStream stream = this.retrieveConfigStream(req);
            id = this.driver.submit(new XmlConfig(stream));
        }
        catch (ConfigException ce) {
            return this.createErrResult(ce.getMessage());
        }
        return this.createSuccResult(id);
    }

    private InputStream retrieveConfigStream(HttpServletRequest request) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        for (FileItem item : upload.parseRequest(request)) {
            if (!item.getFieldName().equals("config")) continue;
            return item.getInputStream();
        }
        throw new BadRequestException();
    }

    private ModelAndView createErrResult(String msg) {
        ModelAndView result = new ModelAndView("submit");
        result.addObject("dInfo", (Object)this.driver.getDriverInfo());
        result.addObject("aInfos", (Object)this.driver.getActiveMissions());
        result.addObject("error", (Object)msg);
        return result;
    }

    private ModelAndView createSuccResult(String id) {
        ModelAndView result = new ModelAndView("submit");
        result.addObject("dInfo", (Object)this.driver.getDriverInfo());
        result.addObject("aInfos", (Object)this.driver.getActiveMissions());
        result.addObject("submitted", (Object)"your mission has been accepted");
        result.addObject("id", (Object)id);
        return result;
    }
}

