/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.web;

import com.intel.cosbench.model.MissionInfo;
import com.intel.cosbench.model.MissionState;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.web.AbstractController;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class MissionPageController
extends AbstractController {
    protected DriverService driver;

    public void setDriver(DriverService driver) {
        this.driver = driver;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String id = req.getParameter("id");
        if (StringUtils.isEmpty((String)id)) {
            throw new BadRequestException();
        }
        return this.process(id);
    }

    protected ModelAndView process(String id) {
        MissionInfo info = this.driver.getMissionInfo(id);
        if (info == null) {
            throw new NotFoundException();
        }
        return this.process(info);
    }

    protected ModelAndView process(MissionInfo info) {
        ModelAndView result = new ModelAndView("mission");
        result.addObject("info", (Object)info);
        result.addObject("dInfo", (Object)this.driver.getDriverInfo());
        result.addObject("isStopped", (Object)MissionState.isStopped((MissionState)info.getState()));
        result.addObject("isRunning", (Object)MissionState.isRunning((MissionState)info.getState()));
        result.addObject("toBeAuthed", (Object)MissionState.allowAuth((MissionState)info.getState()));
        result.addObject("toBeLaunched", (Object)MissionState.allowLaunch((MissionState)info.getState()));
        result.addObject("toBeClosed", (Object)MissionState.allowClose((MissionState)info.getState()));
        return result;
    }
}

