/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.handler;

import com.intel.cosbench.driver.handler.AbstractCommandHandler;
import com.intel.cosbench.protocol.Response;
import com.intel.cosbench.protocol.TriggerResponse;
import com.intel.cosbench.service.DriverService;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class TriggerHandler
extends AbstractCommandHandler {
    private int currPID = 0;
    private int xferPID = 0;
    private boolean isEnable = false;
    protected static String scriptsDir = "scripts/";
    protected DriverService driver;
    protected String scriptLog;

    public void setDriver(DriverService driver) {
        this.driver = driver;
    }

    @Override
    protected Response process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        this.scriptLog = "";
        Scanner scanner = new Scanner((InputStream)req.getInputStream());
        String trigger = this.getTrigger(scanner);
        this.runTrigger(trigger);
        return this.createResponse();
    }

    private String getTrigger(Scanner scanner) {
        String trigger;
        if (!scanner.hasNext()) {
            LOGGER.error("bad request exception");
        }
        if ((trigger = scanner.next()) == null) {
            LOGGER.error("no found exception");
        }
        return trigger;
    }

    private void runTrigger(String trigger) {
        String[] cmdArr = this.getCmdArray(trigger);
        if (cmdArr == null) {
            return;
        }
        LOGGER.info("executing trigger command line : {} on {}", (Object)cmdArr, (Object)this.getDriverName());
        String osType = System.getProperty("os.name").toLowerCase();
        if (osType.contains("linux")) {
            try {
                Process process = Runtime.getRuntime().exec(cmdArr);
                this.getPID(process);
                InputStream is = process.getInputStream();
                BufferedReader buff = new BufferedReader(new InputStreamReader(is));
                String line = null;
                while ((line = buff.readLine()) != null) {
                    this.scriptLog = String.valueOf(this.scriptLog) + line + "\n";
                }
                process.waitFor();
            }
            catch (Exception exception) {
                LOGGER.error("execute trigger command failed!");
                return;
            }
        } else {
            LOGGER.warn("can not execute trigger on {}, the OS type({}) isn't linux!", (Object)this.getDriverName(), (Object)osType);
            return;
        }
        if (!this.isEnable) {
            if (!this.isTriggerKilled(this.currPID)) {
                this.killByPID(this.currPID);
            }
            if (!this.isTriggerKilled(this.xferPID)) {
                this.killByPID(this.xferPID);
            }
        }
    }

    private String[] getCmdArray(String trigger) {
        trigger.replace(" ", "");
        String[] triggerArr = StringUtils.split((String)trigger, (char)',');
        if (triggerArr == null) {
            LOGGER.warn("trigger command array is empty!");
            return null;
        }
        if (triggerArr[0].equals("killTrigger")) {
            this.isEnable = false;
            if (triggerArr.length != 3) {
                LOGGER.error("kill-trigger command line is illegal!");
                return null;
            }
            this.xferPID = this.parsePID(triggerArr[1]);
            String fileName = triggerArr[2];
            String filePath = String.valueOf(scriptsDir) + fileName;
            File tempPath = new File(filePath);
            if (!tempPath.exists() || !tempPath.isFile()) {
                LOGGER.warn("trigger file {} dosen't exist on {}!", (Object)filePath, (Object)this.getDriverName());
                return null;
            }
            return new String[]{"/bin/sh", filePath, "-k"};
        }
        if (triggerArr[0].equals("enableTrigger")) {
            this.isEnable = true;
            String fileName = triggerArr[1];
            String filePath = String.valueOf(scriptsDir) + fileName;
            File tempPath = new File(filePath);
            if (!tempPath.exists() || !tempPath.isFile()) {
                LOGGER.warn("trigger file {} dosen't exist on {}!", (Object)filePath, (Object)this.getDriverName());
                return null;
            }
            String[] cmdArr = new String[triggerArr.length];
            cmdArr[0] = "/bin/sh";
            cmdArr[1] = filePath;
            int i = 2;
            while (i < triggerArr.length) {
                cmdArr[i] = triggerArr[i];
                ++i;
            }
            return cmdArr;
        }
        LOGGER.error("trigger command line is illegal!");
        return null;
    }

    private int parsePID(String str) {
        int num = 0;
        try {
            num = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error("can not parse PID from String to Int {}!", (Object)str);
        }
        return num;
    }

    private void getPID(Process process) {
        Field field = null;
        if (!process.getClass().getName().equals("java.lang.UNIXProcess")) {
            LOGGER.error("failed to get PID by {}", (Object)process.getClass().getName());
            return;
        }
        try {
            field = process.getClass().getDeclaredField("pid");
            field.setAccessible(true);
            this.currPID = (Integer)field.get(process);
        }
        catch (Exception exception) {
            LOGGER.error("get PID failed!");
        }
        if (this.isEnable) {
            this.xferPID = this.currPID;
        }
        LOGGER.debug("current PID is: {}", (Object)this.currPID);
    }

    private boolean isTriggerKilled(int pid) {
        List<Integer> pids = this.getAllPID(pid);
        return pids == null || pids.size() < 1;
    }

    private void killByPID(int pid) {
        List<Integer> pidList = this.getAllPID(pid);
        if (pidList == null || pidList.isEmpty()) {
            return;
        }
        if (pidList.size() != 1) {
            int i = 1;
            while (i < pidList.size()) {
                this.killByPID(pidList.get(i));
                ++i;
            }
        }
        this.runKill9(pid);
    }

    private List<Integer> getAllPID(int pid) {
        if (pid <= 0) {
            LOGGER.warn("pid is illegal: {}", (Object)pid);
            return null;
        }
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        String cmdLine = "ps -ef | grep " + pid + " | awk '{print $2}'";
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmdLine});
            InputStream is = process.getInputStream();
            BufferedReader buff = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = buff.readLine()) != null) {
                int tmp = 0;
                tmp = this.parsePID(line.trim());
                if (tmp <= 0) {
                    LOGGER.error("buffer line is illegal: {}", (Object)line);
                    continue;
                }
                pidList.add(new Integer(tmp));
            }
            process.waitFor();
        }
        catch (Exception exception) {
            LOGGER.error("get all PID failed!");
            return null;
        }
        if (pidList == null || pidList.isEmpty()) {
            return null;
        }
        pidList.remove(pidList.size() - 1);
        pidList.remove(pidList.size() - 1);
        return pidList;
    }

    private void runKill9(int pid) {
        String osType = System.getProperty("os.name").toLowerCase();
        if (osType.contains("linux")) {
            try {
                Runtime.getRuntime().exec(new String[]{"kill", "-9", Integer.toString(pid)});
                LOGGER.debug("pid {} have been killed directly", (Object)pid);
            }
            catch (Exception exception) {
                LOGGER.error("run <kill -9 {}> failed!", (Object)pid);
            }
        } else {
            LOGGER.warn("can not run kill command on {}, the OS type({}) isn't linux!", (Object)this.getDriverName(), (Object)osType);
        }
    }

    private String getDriverName() {
        String name = this.driver.getDriverInfo().getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            LOGGER.warn("can not get local hostname on {}", (Object)this.driver.getDriverInfo().getUrl());
        }
        return name;
    }

    private Response createResponse() {
        TriggerResponse response = new TriggerResponse();
        response.setPID(this.isEnable ? Integer.toString(this.xferPID) : "0");
        response.setScriptLog(this.scriptLog);
        return response;
    }
}

