/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.handler;

import com.intel.cosbench.driver.handler.AbstractCommandHandler;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.protocol.PingResponse;
import com.intel.cosbench.protocol.Response;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.web.BadRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PingHandler
extends AbstractCommandHandler {
    private DriverService driver;

    public void setDriver(DriverService driver) {
        this.driver = driver;
    }

    @Override
    protected Response process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        Scanner scanner = new Scanner((InputStream)req.getInputStream());
        this.setSysTime(this.getControllerTime(scanner));
        PingResponse response = new PingResponse();
        DriverInfo info = this.driver.getDriverInfo();
        response.setName(info.getName());
        response.setAddress(info.getUrl());
        response.setTimeStamp(String.valueOf(System.currentTimeMillis()));
        return response;
    }

    private long getControllerTime(Scanner scanner) throws NumberFormatException {
        if (!scanner.hasNext()) {
            throw new BadRequestException();
        }
        return Long.parseLong(scanner.next());
    }

    private void setSysTime(long ctrTime) throws IOException {
        SimpleDateFormat dateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String[] cmd = new String[]{"date", "-s", dateTime.format(new Date(ctrTime))};
        String osType = System.getProperty("os.name").toLowerCase();
        if (osType.contains("linux")) {
            LOGGER.debug("setting system time {} on driver {}", (Object)ctrTime, (Object)this.driver.getDriverInfo().getName());
            Runtime.getRuntime().exec(cmd);
        } else {
            LOGGER.warn("os type on driver {} is {}!", (Object)this.driver.getDriverInfo().getName(), (Object)osType);
        }
    }
}

