/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.handler;

import com.intel.cosbench.driver.handler.AbstractCommandHandler;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.model.MissionInfo;
import com.intel.cosbench.protocol.Response;
import com.intel.cosbench.service.DriverService;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.InputStream;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

abstract class MissionHandler
extends AbstractCommandHandler {
    protected DriverService driver;
    protected static final Logger LOGGER = LogFactory.getSystemLogger();

    MissionHandler() {
    }

    public void setDriver(DriverService driver) {
        this.driver = driver;
    }

    protected abstract Response process(MissionInfo var1);

    @Override
    protected Response process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        Scanner scanner = new Scanner((InputStream)req.getInputStream());
        MissionInfo info = this.getMissionInfo(scanner);
        return this.process(info);
    }

    private MissionInfo getMissionInfo(Scanner scanner) {
        if (!scanner.hasNext()) {
            throw new BadRequestException();
        }
        MissionInfo info = this.driver.getMissionInfo(scanner.next());
        if (info == null) {
            throw new NotFoundException();
        }
        return info;
    }
}

