/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.handler;

import com.intel.cosbench.bench.Metrics;
import com.intel.cosbench.bench.Report;
import com.intel.cosbench.driver.handler.MissionHandler;
import com.intel.cosbench.model.MissionInfo;
import com.intel.cosbench.model.MissionState;
import com.intel.cosbench.model.TaskState;
import com.intel.cosbench.protocol.CloseResponse;
import com.intel.cosbench.protocol.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class CloseHandler
extends MissionHandler {
    @Override
    protected Response process(MissionInfo info) {
        String id = info.getId();
        this.driver.close(id);
        if (info.getState().equals((Object)MissionState.TERMINATED)) {
            return new Response(false, "close failed");
        }
        return this.getResponse(info);
    }

    private Response getResponse(MissionInfo info) {
        CloseResponse response = new CloseResponse();
        Report report = info.getReport();
        ArrayList<Metrics> wrReport = new ArrayList<Metrics>();
        for (Report wReport : info.getWorkerReports()) {
            for (Metrics metrics : wReport) {
                wrReport.add(metrics);
            }
        }
        response.setWrReport(wrReport);
        response.setReport(Arrays.asList(report.getAllMetrics()));
        if (info.getState().equals((Object)MissionState.FAILED)) {
            response.setState(TaskState.FAILED);
        } else {
            response.setState(TaskState.ACCOMPLISHED);
        }
        String log = null;
        try {
            log = info.getLogManager().getLogAsString();
        }
        catch (IOException iOException) {
            log = "[N/A]";
        }
        response.setErrorStatistics(info.getErrorStatistics().getErrorCodeAndNum());
        response.setDriverLog(log);
        return response;
    }
}

