/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.driver.handler;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.protocol.Response;
import com.intel.cosbench.service.IllegalStateException;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;

abstract class AbstractCommandHandler
implements Controller {
    protected static final Logger LOGGER = LogFactory.getSystemLogger();
    private static final View JSON = new JsonView();

    AbstractCommandHandler() {
    }

    protected abstract Response process(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public ModelAndView handleRequest(HttpServletRequest req, HttpServletResponse res) {
        Response response = null;
        try {
            response = this.process(req, res);
        }
        catch (BadRequestException badRequestException) {
            response = new Response(400, "unrecognized request: " + req.toString());
        }
        catch (NotFoundException notFoundException) {
            response = new Response(404, "mission not found");
        }
        catch (IllegalStateException ise) {
            response = new Response(409, ise.getMessage());
        }
        catch (ConfigException ce) {
            response = new Response(400, ce.getMessage());
        }
        catch (Exception e) {
            response = new Response(500, e.getMessage());
            LOGGER.error("unexpected error", (Throwable)e);
        }
        return new ModelAndView(JSON, "response", (Object)response);
    }

    private static class JsonView
    implements View {
        private ObjectMapper mapper = new ObjectMapper();

        public JsonView() {
            SerializationConfig config = this.mapper.copySerializationConfig();
            config.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
            this.mapper.setSerializationConfig(config);
        }

        public String getContentType() {
            return "application/json";
        }

        public void render(Map<String, ?> model, HttpServletRequest req, HttpServletResponse res) throws Exception {
            Response response = (Response)model.get("response");
            res.setStatus(response.getCode());
            res.setContentType("application/json");
            this.mapper.writeValue((Writer)res.getWriter(), (Object)response);
        }
    }
}

