/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.web;

import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public abstract class AbstractController
implements Controller {
    protected abstract ModelAndView process(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public ModelAndView handleRequest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        ModelAndView result;
        try {
            result = this.process(req, res);
        }
        catch (BadRequestException badRequestException) {
            return new ModelAndView("400");
        }
        catch (NotFoundException notFoundException) {
            return new ModelAndView("404");
        }
        catch (FileNotFoundException fnfe) {
            return new ModelAndView("404", "resource", (Object)fnfe.getMessage());
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            return new ModelAndView("500", "cause", (Object)writer.toString());
        }
        String showDetails = req.getParameter("showDetails");
        result.addObject("showDetails", (Object)Boolean.parseBoolean(showDetails));
        String perfDetails = req.getParameter("perfDetails");
        result.addObject("perfDetails", (Object)Boolean.parseBoolean(perfDetails));
        String showErrorStatistics = req.getParameter("showErrorStatistics");
        result.addObject("showErrorStatistics", (Object)Boolean.parseBoolean(showErrorStatistics));
        return result;
    }
}

