/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.GcsStor;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.StorageScopes;
import com.google.api.services.storage.model.Bucket;
import com.google.api.services.storage.model.StorageObject;
import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;

public class GcsStorage
extends NoneStorage {
    private int timeout;
    private String jsonKeyFile;
    private String projectId;
    private static Storage client;
    private static final JsonFactory JSON_FACTORY;

    static {
        JSON_FACTORY = JacksonFactory.getDefaultInstance();
    }

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.initParms(config);
        try {
            FileInputStream input = new FileInputStream(this.jsonKeyFile);
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)input);
            if (credential.createScopedRequired()) {
                credential = credential.createScoped((Collection)StorageScopes.all());
            }
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            client = new Storage.Builder((HttpTransport)httpTransport, JSON_FACTORY, (HttpRequestInitializer)credential).build();
            logger.debug("GCS client has been initialized");
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void initParms(Config config) {
        this.timeout = config.getInt("timeout", 30000);
        this.parms.put("timeout", (Object)this.timeout);
        this.jsonKeyFile = config.get("jsonkeyfile", "/path/to/json/key/file");
        this.parms.put("jsonkeyfile", (Object)this.jsonKeyFile);
        this.projectId = config.get("projectid", "xxxxx-xxxx");
        this.parms.put("projectid", (Object)this.projectId);
        this.logger.debug("using storage config: {}", (Object)this.parms);
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
    }

    public void dispose() {
        super.dispose();
        client = null;
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            Storage.Objects.Get getRequest = client.objects().get(container, object);
            stream = getRequest.executeMediaAsInputStream();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        Bucket newBucket = new Bucket();
        newBucket.setName(container);
        try {
            Storage.Buckets.Insert bucketInsertRequest = client.buckets().insert(this.projectId, newBucket);
            bucketInsertRequest.execute();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        InputStreamContent contentStream = new InputStreamContent("application/octet-stream", data);
        StorageObject objectMetadata = new StorageObject().setName(object);
        try {
            Storage.Objects.Insert insertRequest = client.objects().insert(container, objectMetadata, (AbstractInputStreamContent)contentStream);
            insertRequest.execute();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            Storage.Buckets.Delete bucketDeleteRequest = client.buckets().delete(container);
            bucketDeleteRequest.execute();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            client.objects().delete(container, object).execute();
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

