/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config.common;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.common.COSBConfigApator;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class KVConfigParser {
    private static Logger logger = LogFactory.getSystemLogger();

    public static Config parse(String str) {
        String[] entries;
        BaseConfiguration config = new BaseConfiguration();
        config.setDelimiterParsingDisabled(true);
        str = StringUtils.trimToEmpty((String)str);
        String[] stringArray = entries = StringUtils.split((String)str, (char)';');
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            KVConfigParser.addConfigEntry(entry, (Configuration)config);
            ++n2;
        }
        return new COSBConfigApator((Configuration)config);
    }

    private static void addConfigEntry(String entry, Configuration config) {
        int pos = StringUtils.indexOf((String)entry, (char)'=');
        if (pos < 0) {
            logger.warn("cannot parse config entry {}", (Object)entry);
        }
        String key = StringUtils.trim((String)StringUtils.left((String)entry, (int)pos));
        String value = StringUtils.trim((String)StringUtils.right((String)entry, (int)(entry.length() - pos - 1)));
        logger.debug("key=" + key + ";value=" + value);
        config.setProperty(key, (Object)value);
    }
}

