/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config.common;

import com.intel.cosbench.config.Config;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.common.COSBConfigApator;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.INIConfiguration;

public class INIConfigParser {
    private static Logger logger = LogFactory.getSystemLogger();

    public static Config parse(File file) {
        INIConfiguration config = null;
        try {
            config = new INIConfiguration(file);
        }
        catch (Exception e) {
            String msg = "cannot loader config from " + file.getAbsolutePath();
            logger.error(msg, (Throwable)e);
            throw new ConfigException(msg, e);
        }
        return new COSBConfigApator((Configuration)config);
    }

    public static Config getEmptyConfig() {
        INIConfiguration config = new INIConfiguration();
        return new COSBConfigApator((Configuration)config);
    }
}

