/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config.castor;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.castor.CastorConfigBase;
import java.io.FileReader;
import java.io.Reader;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;

abstract class CastorConfigResolver
extends CastorConfigBase {
    private Unmarshaller unmarshaller;

    protected abstract Class<?> getExpectedClass();

    public CastorConfigResolver() {
        Unmarshaller unmarshaller;
        XMLContext context = this.getContext();
        this.unmarshaller = unmarshaller = context.createUnmarshaller();
        this.bindClassMetaInfo();
    }

    private void bindClassMetaInfo() {
        Class<?> clazz = this.getExpectedClass();
        this.unmarshaller.setClass(clazz);
        this.unmarshaller.setClassLoader(clazz.getClassLoader());
    }

    protected Object toDomainObject(String path) {
        Reader reader = CastorConfigResolver.loadXmlConfig(path);
        return this.toDomainObject(reader, path);
    }

    private static Reader loadXmlConfig(String path) {
        FileReader reader = null;
        try {
            reader = new FileReader(path);
        }
        catch (Exception e) {
            String msg = "cannot load the xml configuration from " + path;
            msg = String.valueOf(msg) + ", due to " + e.getMessage();
            throw new ConfigException(msg, e);
        }
        return reader;
    }

    protected Object toDomainObject(Reader reader, String path) {
        Object object = null;
        try {
            object = this.unmarshaller.unmarshal(reader);
        }
        catch (Exception e) {
            String msg = "cannot parse the xml configuration from " + path;
            msg = String.valueOf(msg) + ", due to " + e.getMessage();
            throw new ConfigException(msg, e);
        }
        return object;
    }
}

