/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config.castor;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.castor.CastorMappings;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.net.URL;
import java.util.ArrayList;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.XMLContext;

class CastorConfigBase {
    private static Logger logger = LogFactory.getSystemLogger();
    private static XMLContext context = CastorConfigBase.createContext();

    CastorConfigBase() {
    }

    protected XMLContext getContext() {
        return context;
    }

    private static XMLContext createContext() {
        XMLContext context = new XMLContext();
        Mapping mapping = CastorConfigBase.loadMappings();
        try {
            context.addMapping(mapping);
        }
        catch (Exception e) {
            String msg = "cannot add the given castor mapping";
            logger.error(msg, (Throwable)e);
            throw new ConfigException(msg, e);
        }
        return context;
    }

    private static Mapping loadMappings() {
        Mapping mapping = new Mapping();
        URL[] uRLArray = CastorConfigBase.getMappingUrls();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            CastorConfigBase.loadMapping(mapping, url);
            ++n2;
        }
        return mapping;
    }

    private static void loadMapping(Mapping mapping, URL url) {
        try {
            mapping.loadMapping(url);
        }
        catch (Exception e) {
            String msg = "cannot load the given castor mapping";
            logger.error(msg, (Throwable)e);
            throw new ConfigException(msg, e);
        }
        logger.debug("sucessfully loaded mapping from {}", (Object)url);
    }

    private static URL[] getMappingUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(CastorMappings.AUTH);
        urls.add(CastorMappings.STORAGE);
        urls.add(CastorMappings.OPERATION);
        urls.add(CastorMappings.MISSION);
        urls.add(CastorMappings.WORK);
        urls.add(CastorMappings.WORKSTAGE);
        urls.add(CastorMappings.WORKFLOW);
        urls.add(CastorMappings.WORKLOAD);
        return urls.toArray(new URL[urls.size()]);
    }
}

