/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.Workflow;
import com.intel.cosbench.config.common.ConfigUtils;
import org.apache.commons.lang.StringUtils;

public class Workload {
    private static final Auth DEFAULT_AUTH = new Auth("none");
    private static final Storage DEFAULT_STORAGE = new Storage("none");
    private String name;
    private String description;
    private String trigger = null;
    private String config = "";
    private Auth auth = DEFAULT_AUTH;
    private Storage storage = DEFAULT_STORAGE;
    private Workflow workflow;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ConfigException("workload name cannot be empty");
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        if (auth == null) {
            throw new ConfigException("workload must have a default auth");
        }
        this.auth = auth;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        if (storage == null) {
            throw new ConfigException("workload must have a default storage");
        }
        this.storage = storage;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(Workflow workflow) {
        if (workflow == null) {
            throw new ConfigException("workload must have its workflow");
        }
        workflow.setConfig(ConfigUtils.inherit(workflow.getConfig(), this.config));
        this.workflow = workflow;
    }

    public void validate() {
        this.setName(this.getName());
        this.setWorkflow(this.getWorkflow());
        for (Stage stage : this.workflow) {
            if (stage.getAuth() != null) continue;
            stage.setAuth(this.auth);
        }
        for (Stage stage : this.workflow) {
            if (stage.getStorage() != null) continue;
            stage.setStorage(this.storage);
        }
        this.workflow.validate();
    }
}

