/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.common.ConfigUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Workflow
implements Iterable<Stage> {
    private List<Stage> stages;
    private String config = "";

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public List<Stage> getStages() {
        return this.stages;
    }

    public void setStages(List<Stage> stages) {
        if (stages == null || stages.isEmpty()) {
            throw new ConfigException("workflow must have stages");
        }
        for (Stage stage : stages) {
            stage.setConfig(ConfigUtils.inherit(stage.getConfig(), this.config));
        }
        this.stages = stages;
    }

    public void addStage(Stage stage) {
        if (stage == null || stage.getName().isEmpty()) {
            throw new ConfigException("can't add one empty stage");
        }
        if (this.stages == null) {
            this.stages = new ArrayList<Stage>();
        }
        stage.setConfig(ConfigUtils.inherit(stage.getConfig(), this.config));
        this.stages.add(stage);
    }

    @Override
    public Iterator<Stage> iterator() {
        if (this.stages == null) {
            this.stages = new ArrayList<Stage>();
        }
        return this.stages.iterator();
    }

    public void validate() {
        this.setStages(this.getStages());
        for (Stage stage : this.stages) {
            stage.validate();
        }
    }
}

