/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.common.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Work
implements Iterable<Operation> {
    private String name;
    private String type = "normal";
    private int workers;
    private int interval = 5;
    private String division = "none";
    private int runtime = 0;
    private int rampup = 0;
    private int rampdown = 0;
    private int afr = -1;
    private int totalOps = 0;
    private long totalBytes = 0L;
    private String driver;
    private String config = "";
    private Auth auth;
    private Storage storage;
    private List<Operation> operations;

    public Work() {
    }

    public Work(String name) {
        this.setName(name);
    }

    public Work(String name, String type) {
        this.setName(name);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ConfigException("work name cannot be empty");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            throw new ConfigException("work type cannot be empty");
        }
        this.type = type;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        if (workers < 0) {
            throw new ConfigException("illegal workers: " + workers);
        }
        if (workers == 0) {
            throw new ConfigException("must specify 'workers' for a work");
        }
        this.workers = workers;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new ConfigException("illegal interval: " + interval);
        }
        this.interval = interval;
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        if (StringUtils.isEmpty((String)division)) {
            throw new ConfigException("work must have a default division");
        }
        this.division = division;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int runtime) {
        if (runtime < 0) {
            throw new ConfigException("illegal runtime: " + runtime);
        }
        this.runtime = runtime;
    }

    public int getRampup() {
        return this.rampup;
    }

    public void setRampup(int rampup) {
        if (rampup < 0) {
            throw new ConfigException("illegal ramp up time: " + rampup);
        }
        this.rampup = rampup;
    }

    public int getRampdown() {
        return this.rampdown;
    }

    public void setRampdown(int rampdown) {
        if (rampdown < 0) {
            throw new ConfigException("illegal ramp down time: " + rampdown);
        }
        this.rampdown = rampdown;
    }

    public int getTotalOps() {
        return this.totalOps;
    }

    public void setTotalOps(int totalOps) {
        if (totalOps < 0) {
            throw new ConfigException("illegal total ops: " + totalOps);
        }
        this.totalOps = totalOps;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        if (totalBytes < 0L) {
            throw new ConfigException("illegal total bytes: " + totalBytes);
        }
        this.totalBytes = totalBytes;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        if (auth == null) {
            throw new ConfigException("a work must have its auth");
        }
        this.auth = auth;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        if (storage == null) {
            throw new ConfigException("a work must have its storge");
        }
        this.storage = storage;
    }

    public int getAfr() {
        return this.afr;
    }

    public void setAfr(int afr) {
        if (afr > 1000000 || afr < 0) {
            throw new ConfigException("afr should be at 0 to 1000000 range");
        }
        this.afr = afr;
    }

    public List<String> getOperationIDs() {
        ArrayList<String> opIds = new ArrayList<String>();
        for (Operation operation : this.operations) {
            opIds.add(operation.getId());
        }
        return opIds;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        if (operations == null || operations.isEmpty()) {
            throw new ConfigException("a work must have opertations");
        }
        for (Operation op : operations) {
            op.setConfig(ConfigUtils.inherit(op.getConfig(), this.config));
        }
        this.operations = operations;
    }

    public void addOperation(Operation op) {
        if (op == null || op.getType().isEmpty()) {
            throw new ConfigException("a operation must have type");
        }
        if (this.operations == null) {
            this.operations = new ArrayList<Operation>();
        }
        op.setConfig(ConfigUtils.inherit(op.getConfig(), this.config));
        this.operations.add(op);
    }

    @Override
    public Iterator<Operation> iterator() {
        return this.operations.iterator();
    }

    private void toPrepareWork() {
        if (this.name == null) {
            this.name = "prepare";
        }
        this.setDivision("object");
        this.setRuntime(0);
        this.setDefaultAfr(0);
        this.setTotalBytes(0L);
        this.setTotalOps(this.getWorkers());
        Operation op = new Operation();
        op.setType("prepare");
        op.setRatio(100);
        Object[] cfgs = null;
        cfgs = this.config.indexOf("createContainer=") < 0 ? new Object[]{"createContainer=false", this.config} : new Object[]{this.config};
        op.setConfig(StringUtils.join((Object[])cfgs, (char)';'));
        this.setOperations(Collections.singletonList(op));
    }

    private void toCleanupWork() {
        if (this.name == null) {
            this.name = "cleanup";
        }
        this.setDivision("object");
        this.setRuntime(0);
        this.setDefaultAfr(0);
        this.setTotalBytes(0L);
        this.setTotalOps(this.getWorkers());
        Operation op = new Operation();
        op.setType("cleanup");
        op.setRatio(100);
        Object[] cfgs = null;
        cfgs = this.config.indexOf("deleteContainer=") < 0 ? new Object[]{"deleteContainer=false", this.config} : new Object[]{this.config};
        op.setConfig(StringUtils.join((Object[])cfgs, (char)';'));
        this.setOperations(Collections.singletonList(op));
    }

    private void toInitWork() {
        if (this.name == null) {
            this.name = "init";
        }
        this.setDivision("container");
        this.setRuntime(0);
        this.setDefaultAfr(0);
        this.setTotalBytes(0L);
        this.setTotalOps(this.getWorkers());
        Operation op = new Operation();
        op.setType("init");
        op.setRatio(100);
        Object[] cfgs = new Object[]{"objects=r(0,0);sizes=c(0)B", this.config};
        op.setConfig(StringUtils.join((Object[])cfgs, (char)';'));
        this.setOperations(Collections.singletonList(op));
    }

    private void toDisposeWork() {
        if (this.name == null) {
            this.name = "dispose";
        }
        this.setDivision("container");
        this.setRuntime(0);
        this.setDefaultAfr(0);
        this.setTotalBytes(0L);
        this.setTotalOps(this.getWorkers());
        Operation op = new Operation();
        op.setType("dispose");
        op.setRatio(100);
        Object[] cfgs = new Object[]{"objects=r(0,0);sizes=c(0)B", this.config};
        op.setConfig(StringUtils.join((Object[])cfgs, (char)';'));
        this.setOperations(Collections.singletonList(op));
    }

    public void toDelayWork() {
        if (this.name == null) {
            this.name = "delay";
        }
        this.setDivision("none");
        this.setRuntime(0);
        this.setDefaultAfr(0);
        this.setTotalBytes(0L);
        this.setWorkers(1);
        this.setTotalOps(this.getWorkers());
        Operation op = new Operation();
        op.setType("delay");
        op.setRatio(100);
        op.setConfig("");
        this.setOperations(Collections.singletonList(op));
    }

    private void setDefaultAfr(int def) {
        if (this.afr < 0) {
            this.setAfr(def);
        }
    }

    public void validate() {
        if (this.type.equals("prepare")) {
            this.toPrepareWork();
        } else if (this.type.equals("cleanup")) {
            this.toCleanupWork();
        } else if (this.type.equals("init")) {
            this.toInitWork();
        } else if (this.type.equals("dispose")) {
            this.toDisposeWork();
        } else if (this.type.equals("delay")) {
            this.toDelayWork();
        } else {
            this.setDefaultAfr(200000);
        }
        this.setName(this.getName());
        this.setWorkers(this.getWorkers());
        if (this.runtime == 0 && this.totalOps == 0 && this.totalBytes == 0L) {
            throw new ConfigException("no work limits detectd, either runtime, total ops or total bytes");
        }
        this.setAuth(this.getAuth());
        this.auth.validate();
        this.setStorage(this.getStorage());
        this.storage.validate();
        ArrayList<Operation> tempOpList = new ArrayList<Operation>();
        for (Operation op : this.operations) {
            if (op.getRatio() <= 0) continue;
            tempOpList.add(op);
        }
        this.operations = tempOpList;
        this.setOperations(this.getOperations());
        for (Operation op : this.operations) {
            if (op.getDivision() != null) continue;
            op.setDivision(this.division);
        }
        for (Operation op : this.operations) {
            op.validate();
        }
        int sum = 0;
        for (Operation op : this.operations) {
            sum += op.getRatio();
        }
        if (sum != 100) {
            throw new ConfigException("op ratio should sum to 100");
        }
    }
}

