/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.common.ConfigUtils;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Stage
implements Iterable<Work> {
    private String name;
    private int closuredelay;
    private String trigger = null;
    private String config = "";
    private Auth auth;
    private Storage storage;
    private List<Work> works;

    public Stage() {
    }

    public Stage(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ConfigException("stage name cannot be empty");
        }
        if (StringUtils.containsAny((String)name, (String)";")) {
            throw new ConfigException("stage name cannot contain delimiter ';'");
        }
        this.name = name;
    }

    public int getClosuredelay() {
        return this.closuredelay;
    }

    public String getTrigger() {
        return this.trigger;
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setClosuredelay(int closuredelay) {
        if (closuredelay < 0) {
            throw new ConfigException("closure delay cannot be negative");
        }
        this.closuredelay = closuredelay;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        if (auth == null) {
            throw new ConfigException("a stage must have a default auth");
        }
        this.auth = auth;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        if (storage == null) {
            throw new ConfigException("a stage must have a default storage");
        }
        this.storage = storage;
    }

    public List<Work> getWorks() {
        return this.works;
    }

    public void setWorks(List<Work> works) {
        if (works == null || works.isEmpty()) {
            throw new ConfigException("stage must have works");
        }
        for (Work work : works) {
            work.setConfig(ConfigUtils.inherit(work.getConfig(), this.config));
            Logger logger = LogFactory.getSystemLogger();
            logger.debug("stage config: " + this.config + "work inherit result: " + ConfigUtils.inherit(work.getConfig(), this.config));
        }
        this.works = works;
    }

    public void addWork(Work work) {
        if (work == null || work.getName().isEmpty()) {
            throw new ConfigException("can't add one empty work");
        }
        if (this.works == null) {
            this.works = new ArrayList<Work>();
        }
        work.setConfig(ConfigUtils.inherit(work.getConfig(), this.config));
        this.works.add(work);
    }

    @Override
    public Iterator<Work> iterator() {
        return this.works.iterator();
    }

    public void validate() {
        this.setName(this.getName());
        this.setAuth(this.getAuth());
        this.setStorage(this.getStorage());
        this.setWorks(this.getWorks());
        for (Work work : this.works) {
            if (work.getAuth() != null) continue;
            work.setAuth(this.auth);
        }
        for (Work work : this.works) {
            if (work.getStorage() != null) continue;
            work.setStorage(this.storage);
        }
        for (Work work : this.works) {
            work.validate();
        }
    }
}

