/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.config;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.common.ConfigUtils;
import com.intel.cosbench.config.common.KVConfigParser;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Mission
implements Iterable<Operation> {
    private static final Auth DEFAULT_AUTH = new Auth("none");
    private static final Storage DEFAULT_STORAGE = new Storage("none");
    private String name;
    private int workers;
    private int offset = 0;
    private int interval = 5;
    private String division = "none";
    private int runtime = 0;
    private int rampup = 0;
    private int rampdown = 0;
    private int totalOps = 0;
    private long totalBytes = 0L;
    private int totalWorkers;
    private String config = "";
    private Auth auth = DEFAULT_AUTH;
    private Storage storage = DEFAULT_STORAGE;
    private List<Operation> operations;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new ConfigException("mission name cannot be empty");
        }
        this.name = name;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        if (workers < 0) {
            throw new ConfigException("illegal workers: " + workers);
        }
        if (workers == 0) {
            throw new ConfigException("must specify 'workers' for a mission");
        }
        this.workers = workers;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        if (offset < 0) {
            throw new ConfigException("illegal offset: " + offset);
        }
        this.offset = offset;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        if (interval <= 0) {
            throw new ConfigException("illegal interval: " + interval);
        }
        this.interval = interval;
    }

    public String getDivision() {
        return this.division;
    }

    public void setDivision(String division) {
        if (StringUtils.isEmpty((String)division)) {
            throw new ConfigException("mission must have a default division");
        }
        this.division = division;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int runtime) {
        if (runtime < 0) {
            throw new ConfigException("illegal runtime: " + runtime);
        }
        this.runtime = runtime;
    }

    public int getRampup() {
        return this.rampup;
    }

    public void setRampup(int rampup) {
        if (rampup < 0) {
            throw new ConfigException("illegal ramp up time: " + rampup);
        }
        this.rampup = rampup;
    }

    public int getRampdown() {
        return this.rampdown;
    }

    public void setRampdown(int rampdown) {
        if (rampdown < 0) {
            throw new ConfigException("illegal ramp down time: " + rampdown);
        }
        this.rampdown = rampdown;
    }

    public int getTotalOps() {
        return this.totalOps;
    }

    public void setTotalOps(int totalOps) {
        if (totalOps < 0) {
            throw new ConfigException("illegal total ops: " + totalOps);
        }
        this.totalOps = totalOps;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        if (totalBytes < 0L) {
            throw new ConfigException("illegal total bytes: " + totalBytes);
        }
        this.totalBytes = totalBytes;
    }

    public int getTotalWorkers() {
        return this.totalWorkers;
    }

    public void setTotalWorkers(int totalWorkers) {
        if (totalWorkers < 0) {
            throw new ConfigException("illegal total workers: " + totalWorkers);
        }
        if (totalWorkers == 0) {
            throw new ConfigException("must specify 'totalWorkers' for a mission");
        }
        this.totalWorkers = totalWorkers;
    }

    public boolean hasHisto() {
        if (this.config != null) {
            return KVConfigParser.parse(this.config).getBoolean("histo", true);
        }
        return true;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Auth getAuth() {
        return this.auth;
    }

    public void setAuth(Auth auth) {
        if (auth == null) {
            throw new ConfigException("a mission must have its auth");
        }
        this.auth = auth;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        if (storage == null) {
            throw new ConfigException("a mission must have its storge");
        }
        this.storage = storage;
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<Operation> operations) {
        if (operations == null || operations.isEmpty()) {
            throw new ConfigException("a mission must have opertations");
        }
        for (Operation op : operations) {
            op.setConfig(ConfigUtils.inherit(op.getConfig(), this.config));
        }
        this.operations = operations;
    }

    @Override
    public Iterator<Operation> iterator() {
        return this.operations.iterator();
    }

    public void validate() {
        this.setName(this.getName());
        this.setWorkers(this.getWorkers());
        this.setTotalWorkers(this.getTotalWorkers());
        if (this.totalWorkers < this.workers || this.offset + this.workers > this.totalWorkers) {
            throw new ConfigException("conflicting workers, totalWorkers, and offset");
        }
        if (this.runtime == 0 && this.totalOps == 0 && this.totalBytes == 0L) {
            throw new ConfigException("no mission limits detectd, either runtime, total ops or total bytes has been set");
        }
        this.auth.validate();
        this.storage.validate();
        this.setOperations(this.getOperations());
        for (Operation op : this.operations) {
            if (op.getDivision() != null) continue;
            op.setDivision(this.division);
        }
        for (Operation op : this.operations) {
            op.validate();
        }
        int sum = 0;
        for (Operation op : this.operations) {
            sum += op.getRatio();
        }
        if (sum != 100) {
            throw new ConfigException("op ratio should sum to 100");
        }
    }
}

