/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.AbstractController;
import com.intel.cosbench.web.BadRequestException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.servlet.ModelAndView;

public class WorkloadSubmissionController
extends AbstractController {
    private ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String id = null;
        try {
            InputStream stream = this.retrieveConfigStream(req);
            id = this.controller.submit(new XmlConfig(stream));
            this.controller.fire(id);
        }
        catch (ConfigException e) {
            return this.createErrResult(e.getMessage());
        }
        return this.createSuccResult(id);
    }

    private InputStream retrieveConfigStream(HttpServletRequest request) throws Exception {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        for (FileItem item : upload.parseRequest(request)) {
            if (!item.getFieldName().equals("config")) continue;
            return item.getInputStream();
        }
        throw new BadRequestException();
    }

    private ModelAndView createErrResult(String msg) {
        ModelAndView result = new ModelAndView("submit");
        result.addObject("aInfos", (Object)this.controller.getActiveWorkloads());
        result.addObject("error", (Object)msg);
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }

    private ModelAndView createSuccResult(String id) {
        ModelAndView result = new ModelAndView("submit");
        result.addObject("aInfos", (Object)this.controller.getActiveWorkloads());
        result.addObject("submitted", (Object)"your workload has been accepted");
        result.addObject("id", (Object)id);
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }
}

