/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.model.WorkloadState;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.AbstractController;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class WorkloadPageController
extends AbstractController {
    protected ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) {
        String id = req.getParameter("id");
        if (StringUtils.isEmpty((String)id)) {
            throw new BadRequestException();
        }
        return this.process(id);
    }

    protected ModelAndView process(String id) {
        WorkloadInfo info = this.controller.getWorkloadInfo(id);
        if (info == null) {
            throw new NotFoundException();
        }
        if (this.controller.getloadArch() && info.getArchived() && info.getReport().getAllMetrics().length == 0) {
            try {
                this.controller.getWorkloadLoader().loadWorkloadPageInfo(info);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.process(info);
    }

    protected ModelAndView process(WorkloadInfo info) {
        ModelAndView result = new ModelAndView("workload");
        StageInfo stage = info.getCurrentStage();
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        result.addObject("info", (Object)info);
        result.addObject("isStopped", (Object)WorkloadState.isStopped((WorkloadState)info.getState()));
        result.addObject("isRunning", (Object)WorkloadState.isRunning((WorkloadState)info.getState()));
        result.addObject("isStageRunning", (Object)(stage == null ? false : StageState.isRunning((StageState)stage.getState())));
        return result;
    }
}

