/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.controller.web.WorkloadConfigGenerator;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.AbstractController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public class WorkloadMatrixConfigurationController
extends AbstractController {
    protected ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) {
        try {
            this.constructWorkloadConfigsFromPostData(req);
        }
        catch (Exception e) {
            return this.createErrResult(e.getMessage());
        }
        return this.createSuccResult();
    }

    private void constructWorkloadConfigsFromPostData(HttpServletRequest req) throws Exception {
        WorkloadConfigGenerator wlConfGen = new WorkloadConfigGenerator(this.controller);
        wlConfGen.createWorkloadFiles(req);
    }

    private ModelAndView createErrResult(String msg) {
        ModelAndView result = new ModelAndView("advanced-config");
        result.addObject("error", (Object)("ERROR: " + msg));
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }

    private ModelAndView createSuccResult() {
        WorkloadInfo[] aInfos = this.controller.getActiveWorkloads();
        ModelAndView result = new ModelAndView("submit", "aInfos", (Object)aInfos);
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }
}

