/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.Workflow;
import com.intel.cosbench.config.Workload;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.AbstractController;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class WorkloadConfigurationController
extends AbstractController {
    private static final View XML = new XMLView();
    protected ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) {
        Workload workload = null;
        String xml = "";
        try {
            workload = this.constructWorkloadFromPostData(req);
            xml = CastorConfigTools.getWorkloadWriter().toXmlString(workload);
        }
        catch (Exception e) {
            return this.createErrResult(xml, e.getMessage());
        }
        return this.createSuccResult(xml);
    }

    private ArrayList<Object> constructInitStage(HttpServletRequest req) {
        String[] initChecked = req.getParameterValues("init.checked");
        if (initChecked != null) {
            String workStageName = new String("init");
            ArrayList<Object> workStageList = new ArrayList<Object>();
            int i = 0;
            while (i < initChecked.length) {
                if (i > 0) {
                    workStageName = new String("init" + i);
                }
                Stage stage = new Stage(workStageName);
                Work work = new Work(workStageName, "init");
                work.setWorkers(this.getParmInt(req.getParameterValues("init.workers")[i], 1));
                work.setDivision("container");
                String config = "";
                String selector = req.getParameterValues("init.containers")[i];
                String min = req.getParameterValues("init.containers.min")[i];
                String max = req.getParameterValues("init.containers.max")[i];
                config = "containers=" + selector + "(" + min + "," + max + ")";
                work.setConfig(config);
                stage.addWork(work);
                workStageList.add(stage);
                this.checkAndAddDelay(req, "init", workStageList, i);
                ++i;
            }
            return workStageList;
        }
        return null;
    }

    private ArrayList<Object> constructPrepareStage(HttpServletRequest req) {
        String[] prepareChecked = req.getParameterValues("prepare.checked");
        if (prepareChecked != null) {
            String workStageName = new String("prepare");
            ArrayList<Object> workStageList = new ArrayList<Object>();
            int i = 0;
            while (i < prepareChecked.length) {
                if (i > 0) {
                    workStageName = new String("prepare" + i);
                }
                Stage stage = new Stage(workStageName);
                Work work = new Work(workStageName, "prepare");
                work.setWorkers(this.getParmInt(req.getParameterValues("prepare.workers")[i], 1));
                work.setDivision("object");
                String config = "";
                String cselector = req.getParameterValues("prepare.containers")[i];
                String cmin = req.getParameterValues("prepare.containers.min")[i];
                String cmax = req.getParameterValues("prepare.containers.max")[i];
                config = String.valueOf(config) + "containers=" + cselector + "(" + cmin + "," + cmax + ");";
                String oselector = req.getParameterValues("prepare.objects")[i];
                String omin = req.getParameterValues("prepare.objects.min")[i];
                String omax = req.getParameterValues("prepare.objects.max")[i];
                config = String.valueOf(config) + "objects=" + oselector + "(" + omin + "," + omax + ");";
                String sselector = this.getParm(req, "prepare.sizes");
                String smin = req.getParameterValues("prepare.sizes.min")[i];
                String smax = req.getParameterValues("prepare.sizes.max")[i];
                String sunit = req.getParameterValues("prepare.sizes.unit")[i];
                String sexp = "";
                if ("u".equals(sselector)) {
                    sexp = String.valueOf(sselector) + "(" + smin + "," + smax + ")" + sunit;
                }
                if ("c".equals(sselector)) {
                    sexp = String.valueOf(sselector) + "(" + smin + ")" + sunit;
                }
                config = String.valueOf(config) + "sizes=" + sexp;
                work.setConfig(config);
                stage.addWork(work);
                workStageList.add(stage);
                this.checkAndAddDelay(req, "prepare", workStageList, i);
                ++i;
            }
            return workStageList;
        }
        return null;
    }

    private ArrayList<Object> constructCleanupStage(HttpServletRequest req) {
        String[] cleanupChecked = req.getParameterValues("cleanup.checked");
        if (cleanupChecked != null) {
            String workStageName = new String("cleanup");
            ArrayList<Object> workStageList = new ArrayList<Object>();
            int i = 0;
            while (i < cleanupChecked.length) {
                if (i > 0) {
                    workStageName = new String("cleanup" + i);
                }
                Stage stage = new Stage(workStageName);
                Work work = new Work(workStageName, "cleanup");
                work.setWorkers(this.getParmInt(req.getParameterValues("cleanup.workers")[i], 1));
                work.setDivision("object");
                String config = "";
                String cselector = req.getParameterValues("cleanup.containers")[i];
                String cmin = req.getParameterValues("cleanup.containers.min")[i];
                String cmax = req.getParameterValues("cleanup.containers.max")[i];
                config = String.valueOf(config) + "containers=" + cselector + "(" + cmin + "," + cmax + ");";
                String oselector = req.getParameterValues("cleanup.objects")[i];
                String omin = req.getParameterValues("cleanup.objects.min")[i];
                String omax = req.getParameterValues("cleanup.objects.max")[i];
                config = String.valueOf(config) + "objects=" + oselector + "(" + omin + "," + omax + ");";
                work.setConfig(config);
                stage.addWork(work);
                workStageList.add(stage);
                this.checkAndAddDelay(req, "cleanup", workStageList, i);
                ++i;
            }
            return workStageList;
        }
        return null;
    }

    private ArrayList<Object> constructDisposeStage(HttpServletRequest req) {
        String[] disposeChecked = req.getParameterValues("dispose.checked");
        if (disposeChecked != null) {
            String workStageName = new String("dispose");
            ArrayList<Object> workStageList = new ArrayList<Object>();
            int i = 0;
            while (i < disposeChecked.length) {
                if (i > 0) {
                    workStageName = new String("dispose" + i);
                }
                Stage stage = new Stage(workStageName);
                Work work = new Work(workStageName, "dispose");
                work.setWorkers(this.getParmInt(req.getParameterValues("dispose.workers")[i], 1));
                work.setDivision("container");
                String config = "";
                String cselector = req.getParameterValues("dispose.containers")[i];
                String cmin = req.getParameterValues("dispose.containers.min")[i];
                String cmax = req.getParameterValues("dispose.containers.max")[i];
                config = String.valueOf(config) + "containers=" + cselector + "(" + cmin + "," + cmax + ");";
                work.setConfig(config);
                stage.addWork(work);
                workStageList.add(stage);
                this.checkAndAddDelay(req, "dispose", workStageList, i);
                ++i;
            }
            return workStageList;
        }
        return null;
    }

    private String getParm(HttpServletRequest req, String parm) {
        return req.getParameter(parm);
    }

    private ArrayList<Object> constructNormalStage(HttpServletRequest req) {
        String[] normalChecked = req.getParameterValues("normal.checked");
        if (normalChecked != null) {
            String workStageName = new String("normal");
            ArrayList<Object> workStageList = new ArrayList<Object>();
            int i = 0;
            while (i < normalChecked.length) {
                int dRatio;
                int fwRatio;
                int wRatio;
                if (i > 0) {
                    workStageName = new String("normal" + i);
                }
                Stage stage = new Stage(workStageName);
                Work work = new Work(workStageName, "normal");
                work.setWorkers(this.getParmInt(req.getParameterValues("normal.workers")[i]));
                work.setRampup(this.getParmInt(req.getParameterValues("normal.rampup")[i]));
                work.setRuntime(this.getParmInt(req.getParameterValues("normal.runtime")[i]));
                int rRatio = this.getParmInt(req.getParameterValues("read.ratio")[i], 0);
                if (rRatio > 0) {
                    String rconfig = "";
                    Operation rOp = new Operation("read");
                    rOp.setRatio(rRatio);
                    String rcselector = req.getParameterValues("read.containers")[i];
                    String rcmin = req.getParameterValues("read.containers.min")[i];
                    String rcmax = req.getParameterValues("read.containers.max")[i];
                    rconfig = String.valueOf(rconfig) + "containers=" + rcselector + "(" + rcmin + "," + rcmax + ");";
                    String roselector = req.getParameterValues("read.objects")[i];
                    String romin = req.getParameterValues("read.objects.min")[i];
                    String romax = req.getParameterValues("read.objects.max")[i];
                    rconfig = String.valueOf(rconfig) + "objects=" + roselector + "(" + romin + "," + romax + ");";
                    rOp.setConfig(rconfig);
                    work.addOperation(rOp);
                }
                if ((wRatio = this.getParmInt(req.getParameterValues("write.ratio")[i], 0)) > 0) {
                    String wconfig = "";
                    Operation wOp = new Operation("write");
                    wOp.setRatio(wRatio);
                    String wcselector = req.getParameterValues("write.containers")[i];
                    String wcmin = req.getParameterValues("write.containers.min")[i];
                    String wcmax = req.getParameterValues("write.containers.max")[i];
                    wconfig = String.valueOf(wconfig) + "containers=" + wcselector + "(" + wcmin + "," + wcmax + ");";
                    String woselector = req.getParameterValues("write.objects")[i];
                    String womin = req.getParameterValues("write.objects.min")[i];
                    String womax = req.getParameterValues("write.objects.max")[i];
                    wconfig = String.valueOf(wconfig) + "objects=" + woselector + "(" + womin + "," + womax + ");";
                    String wsselector = req.getParameterValues("write.sizes")[i];
                    String wsmin = req.getParameterValues("write.sizes.min")[i];
                    String wsmax = req.getParameterValues("write.sizes.max")[i];
                    String wsunit = req.getParameterValues("write.sizes.unit")[i];
                    String wsexp = "";
                    if ("u".equals(wsselector) || "r".equals(wsselector)) {
                        wsexp = String.valueOf(wsselector) + "(" + wsmin + "," + wsmax + ")" + wsunit;
                    }
                    if ("c".equals(wsselector)) {
                        wsexp = String.valueOf(wsselector) + "(" + wsmin + ")" + wsunit;
                    }
                    wconfig = String.valueOf(wconfig) + "sizes=" + wsexp;
                    wOp.setConfig(wconfig);
                    work.addOperation(wOp);
                }
                if ((fwRatio = this.getParmInt(req.getParameterValues("filewrite.ratio")[i], 0)) > 0) {
                    String fwconfig = "";
                    Operation fwOp = new Operation("filewrite");
                    fwOp.setRatio(fwRatio);
                    String fwcselector = req.getParameterValues("filewrite.containers")[i];
                    String fwcmin = req.getParameterValues("filewrite.containers.min")[i];
                    String fwcmax = req.getParameterValues("filewrite.containers.max")[i];
                    fwconfig = String.valueOf(fwconfig) + "containers=" + fwcselector + "(" + fwcmin + "," + fwcmax + ");";
                    String fwoselector = req.getParameterValues("filewrite.fileselection")[i];
                    fwconfig = String.valueOf(fwconfig) + "fileselection=" + fwoselector + ";";
                    String fwfselector = req.getParameterValues("filewrite.files")[i];
                    fwconfig = String.valueOf(fwconfig) + "files=" + fwfselector;
                    fwOp.setConfig(fwconfig);
                    work.addOperation(fwOp);
                }
                if ((dRatio = this.getParmInt(req.getParameterValues("delete.ratio")[i], 0)) > 0) {
                    String dconfig = "";
                    Operation dOp = new Operation("delete");
                    dOp.setRatio(dRatio);
                    String dcselector = req.getParameterValues("delete.containers")[i];
                    String dcmin = req.getParameterValues("delete.containers.min")[i];
                    String dcmax = req.getParameterValues("delete.containers.max")[i];
                    dconfig = String.valueOf(dconfig) + "containers=" + dcselector + "(" + dcmin + "," + dcmax + ");";
                    String doselector = req.getParameterValues("delete.objects")[i];
                    String domin = req.getParameterValues("delete.objects.min")[i];
                    String domax = req.getParameterValues("delete.objects.max")[i];
                    dconfig = String.valueOf(dconfig) + "objects=" + doselector + "(" + domin + "," + domax + ");";
                    dOp.setConfig(dconfig);
                    work.addOperation(dOp);
                }
                stage.addWork(work);
                workStageList.add(stage);
                this.checkAndAddDelay(req, "normal", workStageList, i);
                ++i;
            }
            return workStageList;
        }
        return null;
    }

    private int getParmInt(String string, int defVal) {
        if (string != null) {
            return Integer.parseInt(string);
        }
        return defVal;
    }

    private int getParmInt(String string) {
        return Integer.parseInt(string);
    }

    private void checkAndAddDelay(HttpServletRequest req, String stage, ArrayList<Object> workStageList, int iteration) {
        boolean hasDelay;
        String[] delayChecked = req.getParameterValues(String.valueOf(stage) + ".delay.checked");
        if (delayChecked != null && (hasDelay = "on".equalsIgnoreCase(delayChecked[iteration]))) {
            Stage delayStage = new Stage("delay");
            delayStage.setClosuredelay(this.getParmInt(req.getParameterValues("init.delay.closuredelay")[iteration], 60));
            Work work = new Work("delay", "delay");
            work.addOperation(new Operation("delay"));
            delayStage.addWork(work);
            workStageList.add(delayStage);
        }
    }

    private Storage removeNSROOTConfig(Storage storage) {
        if (storage.getConfig() == null) {
            return storage;
        }
        if (!storage.getConfig().contains("nsroot")) {
            return storage;
        }
        Storage newStorage = new Storage();
        String[] configParams = storage.getConfig().split(";");
        StringBuffer newConfig = new StringBuffer("");
        String[] stringArray = configParams;
        int n = configParams.length;
        int n2 = 0;
        while (n2 < n) {
            String configParam = stringArray[n2];
            if (!configParam.toLowerCase().contains("nsroot")) {
                newConfig.append(String.valueOf(configParam) + ";");
            }
            ++n2;
        }
        newConfig.deleteCharAt(newConfig.length() - 1);
        newStorage.setType(storage.getType());
        newStorage.setConfig(newConfig.toString());
        return newStorage;
    }

    private Workload constructWorkloadFromPostData(HttpServletRequest req) throws Exception {
        ArrayList<Object> disposeStageList;
        ArrayList<Object> cleanupStageList;
        ArrayList<Object> normalStageList;
        ArrayList<Object> prepareStageList;
        Workload workload = new Workload();
        String name = this.getParm(req, "workload.name");
        if (name == null || name.isEmpty()) {
            name = "workload";
        }
        String desc = this.getParm(req, "workload.desc");
        workload.setName(name);
        workload.setDescription(desc);
        workload.setAuth(new Auth(this.getParm(req, "auth.type"), this.getParm(req, "auth.config")));
        workload.setStorage(new Storage(this.getParm(req, "storage.type"), this.getParm(req, "storage.config")));
        Workflow workflow = new Workflow();
        ArrayList<Object> initStageList = this.constructInitStage(req);
        if (initStageList != null) {
            int i = 0;
            while (i < initStageList.size()) {
                workflow.addStage((Stage)initStageList.get(i));
                ++i;
            }
        }
        if ((prepareStageList = this.constructPrepareStage(req)) != null) {
            int i = 0;
            while (i < prepareStageList.size()) {
                Stage stage = (Stage)prepareStageList.get(i);
                stage.setStorage(this.removeNSROOTConfig(workload.getStorage()));
                workflow.addStage(stage);
                ++i;
            }
        }
        if ((normalStageList = this.constructNormalStage(req)) != null) {
            int i = 0;
            while (i < normalStageList.size()) {
                Stage stage = (Stage)normalStageList.get(i);
                stage.setStorage(this.removeNSROOTConfig(workload.getStorage()));
                workflow.addStage(stage);
                ++i;
            }
        }
        if ((cleanupStageList = this.constructCleanupStage(req)) != null) {
            int i = 0;
            while (i < cleanupStageList.size()) {
                Stage stage = (Stage)cleanupStageList.get(i);
                stage.setStorage(this.removeNSROOTConfig(workload.getStorage()));
                workflow.addStage(stage);
                ++i;
            }
        }
        if ((disposeStageList = this.constructDisposeStage(req)) != null) {
            int i = 0;
            while (i < disposeStageList.size()) {
                workflow.addStage((Stage)disposeStageList.get(i));
                ++i;
            }
        }
        workload.setWorkflow(workflow);
        workload.validate();
        return workload;
    }

    private ModelAndView createErrResult(String xml, String msg) {
        ModelAndView result = new ModelAndView("config", "xml", (Object)xml);
        result.addObject("error", (Object)("ERROR: " + msg));
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }

    private ModelAndView createSuccResult(String xml) {
        ModelAndView result = new ModelAndView(XML, "xml", (Object)xml);
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }

    private static class XMLView
    implements View {
        private XMLView() {
        }

        public String getContentType() {
            return "application/xml";
        }

        public void render(Map<String, ?> model, HttpServletRequest req, HttpServletResponse res) throws Exception {
            String xml = (String)model.get("xml");
            res.setHeader("Content-Length", String.valueOf(xml.length()));
            res.setHeader("Content-Disposition", "attachment; filename=\"workload-config.xml\"");
            IOUtils.write((String)xml, (OutputStream)res.getOutputStream());
        }
    }
}

