/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.config.Auth;
import com.intel.cosbench.config.Operation;
import com.intel.cosbench.config.Stage;
import com.intel.cosbench.config.Storage;
import com.intel.cosbench.config.Work;
import com.intel.cosbench.config.Workflow;
import com.intel.cosbench.config.Workload;
import com.intel.cosbench.config.XmlConfig;
import com.intel.cosbench.config.castor.CastorConfigTools;
import com.intel.cosbench.log.LogFactory;
import com.intel.cosbench.log.Logger;
import com.intel.cosbench.service.ControllerService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;

public class WorkloadConfigGenerator {
    private String runtime;
    private String delay;
    private String rampup;
    private String num_of_drivers;
    private String auth_type;
    private String auth_config;
    private String storage_type;
    private String storage_config;
    private boolean generateWorkloadFiles;
    private File WORKLOAD_CONFIG_DIR;
    private static final String workloadConfigFilesRoot = "workloads";
    protected ControllerService controller;
    private static final Logger LOGGER = LogFactory.getSystemLogger();

    public WorkloadConfigGenerator(ControllerService controller) {
        this.controller = controller;
    }

    public void createWorkloadFiles(HttpServletRequest req) throws Exception {
        this.setWorkloadParams(req);
        String workloadMatrixName = req.getParameter("workload.matrix.name");
        if (!workloadMatrixName.matches("[a-zA-Z0-9\\_\\-#\\.\\(\\)\\/%&]{3,50}")) {
            throw new Exception("Workload Matrix Name incorrect. Please use alphabets or numbers. Special characters allowed are _ - # . ( ) / % &. Length should be between 3 to 50 characters.");
        }
        String[] objectSizeStrings = req.getParameterValues("object-sizes");
        if (objectSizeStrings == null) {
            return;
        }
        int i = 0;
        while (i < objectSizeStrings.length) {
            String workloadName = req.getParameterValues("workload.name")[i];
            if (!workloadName.matches("[a-zA-Z0-9\\_\\-#\\.\\(\\)\\/%&]{3,50}")) {
                throw new Exception("Workload Name incorrect. Please use alphabets or numbers. Special characters allowed are _ - # . ( ) / % &. Length should be between 3 to 50 characters.");
            }
            ++i;
        }
        String[] workloadNumbers = req.getParameterValues("workload-number");
        int i2 = 0;
        while (i2 < workloadNumbers.length) {
            boolean isRange;
            String unit;
            String[] objectSizes;
            int workloadNumber = Integer.parseInt(workloadNumbers[i2]);
            String objectSizeString = objectSizeStrings[i2];
            if (objectSizeString.contains("-")) {
                objectSizes = objectSizeString.split("-");
                unit = req.getParameterValues("object-size-unit")[i2];
                isRange = true;
            } else {
                objectSizes = objectSizeString.split(",");
                unit = req.getParameterValues("object-size-unit")[i2];
                isRange = false;
            }
            String[] objects = req.getParameterValues("num-of-objects")[i2].split(",");
            String[] containers = req.getParameterValues("num-of-containers")[i2].split(",");
            String[] rWDRatios = this.getRWDRatios(req, String.valueOf(workloadNumber));
            String[] workers = req.getParameterValues("workers")[i2].split(",");
            Workload workload = this.constructWorkload(req, objectSizes, containers, objects, workers, rWDRatios, isRange, unit);
            workload.validate();
            String workloadName = req.getParameterValues("workload.name")[workloadNumber];
            workload.setName(workloadName);
            if (this.generateWorkloadFiles) {
                this.WORKLOAD_CONFIG_DIR = new File("workloads/" + workloadMatrixName);
                if (!this.WORKLOAD_CONFIG_DIR.exists()) {
                    this.WORKLOAD_CONFIG_DIR.mkdirs();
                }
                String path = this.WORKLOAD_CONFIG_DIR.getAbsolutePath();
                LOGGER.info("using {} for storing generated workload configs", (Object)path);
                this.printWorkloadConfigXML(workload, workloadName);
            } else {
                this.submitWorkload(workload);
            }
            ++i2;
        }
    }

    private String[] getRWDRatios(HttpServletRequest req, String workloadNumber) {
        String[] readRatios = req.getParameterValues("read-ratio" + workloadNumber);
        String[] writeRatios = req.getParameterValues("write-ratio" + workloadNumber);
        String[] deleteRatios = req.getParameterValues("delete-ratio" + workloadNumber);
        String[] rwdRatios = new String[readRatios.length];
        int i = 0;
        while (i < readRatios.length) {
            rwdRatios[i] = String.valueOf(readRatios[i]) + "," + writeRatios[i] + "," + deleteRatios[i];
            ++i;
        }
        return rwdRatios;
    }

    private void submitWorkload(Workload workload) {
        String workloadXml = CastorConfigTools.getWorkloadWriter().toXmlString(workload);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(workloadXml.getBytes());
        String id = this.controller.submit(new XmlConfig((InputStream)inputStream));
        this.controller.fire(id);
    }

    private void printWorkloadConfigXML(Workload workload, String workloadName) {
        try {
            String workloadXml = CastorConfigTools.getWorkloadWriter().toXmlString(workload);
            PrintWriter out = new PrintWriter(new File(this.WORKLOAD_CONFIG_DIR + "/" + workloadName + ".xml"));
            out.print(workloadXml);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void setWorkloadParams(HttpServletRequest req) {
        this.auth_type = req.getParameter("auth.type");
        this.auth_config = req.getParameter("auth.config");
        this.storage_type = req.getParameter("storage.type");
        this.storage_config = req.getParameter("storage.config");
        this.runtime = req.getParameter("runtime");
        this.delay = req.getParameter("delay");
        this.rampup = req.getParameter("rampup");
        this.num_of_drivers = req.getParameter("num_of_drivers");
        this.generateWorkloadFiles = req.getParameter("generate-workload") != null;
    }

    public Workload constructWorkload(HttpServletRequest req, String[] objectSizes, String[] containers, String[] objects, String[] workers, String[] rwdRatios, boolean isRange, String unit) {
        Workload workload = new Workload();
        String name = "workload";
        String desc = "workload description";
        workload.setName(name);
        workload.setDescription(desc);
        workload.setAuth(new Auth(this.auth_type, this.auth_config));
        workload.setStorage(new Storage(this.storage_type, this.storage_config));
        Workflow workflow = new Workflow();
        int objectSizesLength = isRange ? 1 : objectSizes.length;
        String init_workers = this.num_of_drivers;
        this.addInitStages(workflow, objectSizesLength, containers, objectSizes, objects, isRange, unit, init_workers);
        this.addPrepareStages(workflow, objectSizesLength, objectSizes, objects, containers, isRange, unit, workers);
        this.addNormalStages(workflow, objectSizesLength, objectSizes, objects, containers, isRange, unit, workers, rwdRatios);
        this.addCleanupStages(workflow, objectSizesLength, objectSizes, objects, containers, isRange, unit);
        this.addDisposeStages(workflow, objectSizesLength, objectSizes, containers, isRange, unit);
        workload.setWorkflow(workflow);
        return workload;
    }

    private void addDisposeStages(Workflow workflow, int objectSizesLength, String[] objectSizes, String[] containers, boolean isRange, String unit) {
        int previousContainerValue = 0;
        int i = 0;
        while (i < objectSizesLength) {
            int j = 0;
            while (j < containers.length) {
                String containerString = containers[j];
                String from_container = String.valueOf(previousContainerValue + Integer.valueOf(containerString));
                String to_container = String.valueOf(Integer.valueOf(from_container) + Integer.valueOf(containerString) - 1);
                previousContainerValue = Integer.valueOf(to_container);
                String sizeString = isRange ? "(" + objectSizes[0] + "," + objectSizes[1] + ")" + unit : "(" + objectSizes[i] + ")" + unit;
                String numworkers = this.num_of_drivers;
                int numcontainers = Integer.valueOf(to_container) - Integer.valueOf(from_container) + 1;
                String stageName = "w" + sizeString + "_c" + numcontainers + "_dispose_" + numworkers;
                String configLine = "containers=r(" + from_container + "," + to_container + ")";
                Stage stage = this.createAWorkstage(workflow, stageName, "dispose", String.valueOf(numworkers), configLine);
                workflow.addStage(stage);
                ++j;
            }
            ++i;
        }
    }

    private void addCleanupStages(Workflow workflow, int objectSizesLength, String[] objectSizes, String[] objects, String[] containers, boolean isRange, String unit) {
        int previousContainerValue = 0;
        int previousObjectValue = 0;
        int i = 0;
        while (i < objectSizesLength) {
            int j = 0;
            while (j < containers.length) {
                int k = 0;
                while (k < objects.length) {
                    String containerString = containers[j];
                    String from_container = String.valueOf(previousContainerValue + Integer.valueOf(containerString));
                    String to_container = String.valueOf(Integer.valueOf(from_container) + Integer.valueOf(containerString) - 1);
                    previousContainerValue = Integer.valueOf(to_container);
                    String from_object = String.valueOf(previousObjectValue + 1);
                    String to_object = String.valueOf(Integer.valueOf(from_object) + Integer.valueOf(objects[k]) - 1);
                    previousObjectValue = Integer.valueOf(to_object);
                    String sizeString = isRange ? "(" + objectSizes[0] + "," + objectSizes[1] + ")" + unit : "(" + objectSizes[i] + ")" + unit;
                    String numworkers = this.num_of_drivers;
                    int numcontainers = Integer.valueOf(to_container) - Integer.valueOf(from_container) + 1;
                    int numobjects = Integer.valueOf(to_object) - Integer.valueOf(from_object) + 1;
                    String stageName = "w" + sizeString + "_c" + numcontainers + "_o" + numobjects + "_cleanup_" + numworkers;
                    String configLine = "containers=r(" + from_container + "," + to_container + ");objects=r(" + from_object + "," + to_object + ")";
                    Stage stage = this.createAWorkstage(workflow, stageName, "cleanup", String.valueOf(numworkers), configLine);
                    workflow.addStage(stage);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addNormalStages(Workflow workflow, int objectSizesLength, String[] objectSizes, String[] objects, String[] containers, boolean isRange, String unit, String[] workers, String[] rwdRatios) {
        int previousContainerValue = 0;
        int previousObjectValue = 0;
        int i = 0;
        while (i < objectSizesLength) {
            int j = 0;
            while (j < containers.length) {
                int k = 0;
                while (k < objects.length) {
                    String sizeString = isRange ? "(" + objectSizes[0] + "," + objectSizes[1] + ")" + unit : "(" + objectSizes[i] + ")" + unit;
                    String containerString = containers[j];
                    String from_container = String.valueOf(previousContainerValue + Integer.valueOf(containerString));
                    String to_container = String.valueOf(Integer.valueOf(from_container) + Integer.valueOf(containerString) - 1);
                    previousContainerValue = Integer.valueOf(to_container);
                    String from_object = String.valueOf(previousObjectValue + 1);
                    String to_object = String.valueOf(Integer.valueOf(from_object) + Integer.valueOf(objects[k]) - 1);
                    previousObjectValue = Integer.valueOf(to_object);
                    int w = 0;
                    while (w < workers.length) {
                        int r = 0;
                        while (r < rwdRatios.length) {
                            String[] readWriteDeleteRatios = rwdRatios[r].split(",");
                            String readRatio = readWriteDeleteRatios[0];
                            String writeRatio = readWriteDeleteRatios[1];
                            String deleteRatio = readWriteDeleteRatios[2];
                            Stage stage = this.createNormalWorkstage(workflow, workers[w], this.runtime, readRatio, writeRatio, deleteRatio, isRange, from_container, to_container, from_object, to_object, sizeString);
                            workflow.addStage(stage);
                            ++r;
                        }
                        ++w;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addPrepareStages(Workflow workflow, int objectSizesLength, String[] objectSizes, String[] objects, String[] containers, boolean isRange, String unit, String[] workers) {
        int previousContainerValue = 0;
        int previousObjectValue = 0;
        int i = 0;
        while (i < objectSizesLength) {
            int j = 0;
            while (j < containers.length) {
                int k = 0;
                while (k < objects.length) {
                    String sizeString;
                    String containerString = containers[j];
                    String from_container = String.valueOf(previousContainerValue + Integer.valueOf(containerString));
                    String to_container = String.valueOf(Integer.valueOf(from_container) + Integer.valueOf(containerString) - 1);
                    previousContainerValue = Integer.valueOf(to_container);
                    String from_object = String.valueOf(previousObjectValue + 1);
                    String to_object = String.valueOf(Integer.valueOf(from_object) + Integer.valueOf(objects[k]) - 1);
                    previousObjectValue = Integer.valueOf(to_object);
                    int numworkers = Integer.valueOf(objects[k]) / Integer.valueOf(this.num_of_drivers);
                    int numcontainers = Integer.valueOf(to_container) - Integer.valueOf(from_container) + 1;
                    int numobjects = Integer.valueOf(to_object) - Integer.valueOf(from_object) + 1;
                    String sizeSpec = "";
                    if (isRange) {
                        sizeString = "(" + objectSizes[0] + "-" + objectSizes[1] + ")" + unit;
                        sizeSpec = "u";
                    } else {
                        sizeString = "(" + objectSizes[i] + ")" + unit;
                        sizeSpec = "c";
                    }
                    String stageName = "w" + sizeString + "_c" + numcontainers + "_o" + numobjects + "_prepare_" + numworkers;
                    String configLine = "containers=r(" + from_container + "," + to_container + ");objects=r(" + from_object + "," + to_object + ");sizes=" + sizeSpec + sizeString;
                    Stage stage = this.createAWorkstage(workflow, stageName, "prepare", String.valueOf(numworkers), configLine);
                    workflow.addStage(stage);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void addInitStages(Workflow workflow, int objectSizesLength, String[] containers, String[] objectSizes, String[] objects, boolean isRange, String unit, String init_workers) {
        int previousContainerValue = 0;
        int i = 0;
        while (i < objectSizesLength) {
            int j = 0;
            while (j < containers.length) {
                String containerString = containers[j];
                String from_container = String.valueOf(previousContainerValue + Integer.valueOf(containerString));
                String to_container = String.valueOf(Integer.valueOf(from_container) + Integer.valueOf(containerString) - 1);
                previousContainerValue = Integer.valueOf(to_container);
                String sizeString = isRange ? "(" + objectSizes[0] + "," + objectSizes[1] + ")" + unit : "(" + objectSizes[i] + ")" + unit;
                int numcontainers = Integer.valueOf(to_container) - Integer.valueOf(from_container) + 1;
                String stageName = "w" + sizeString + "_c" + numcontainers + "_init_" + init_workers;
                String config = "containers=r(" + from_container + "," + to_container + ")";
                Stage stage = this.createAWorkstage(workflow, stageName, "init", init_workers, config);
                workflow.addStage(stage);
                ++j;
            }
            ++i;
        }
    }

    private Stage createAWorkstage(Workflow workflow, String stageName, String stageType, String workers, String config) {
        Stage stage = new Stage(stageName);
        Work work = new Work(stageName, stageType);
        work.setType(stageType);
        work.setWorkers(Integer.parseInt(workers));
        work.setConfig(config);
        stage.addWork(work);
        return stage;
    }

    private Stage createNormalWorkstage(Workflow workflow, String workers, String runtime, String readRatio, String writeRatio, String deleteRatio, boolean isRange, String from_container, String to_container, String from_object, String to_object, String sizeString) {
        String writeConfig;
        String stageName = "w" + sizeString + "_c" + (Integer.valueOf(to_container) - Integer.valueOf(from_container) + 1) + "_o" + (Integer.valueOf(to_object) - Integer.valueOf(from_object) + 1) + "_r" + readRatio + "w" + writeRatio + "d" + deleteRatio + "_" + workers;
        Stage stage = new Stage(stageName);
        stage.setClosuredelay(Integer.parseInt(this.delay));
        Work work = new Work("main", "normal");
        work.setWorkers(Integer.parseInt(workers));
        work.setRampup(Integer.parseInt(this.rampup));
        work.setRuntime(Integer.parseInt(runtime));
        stage.addWork(work);
        Operation readOp = new Operation("read");
        readOp.setRatio(Integer.parseInt(readRatio));
        String readConfig = "containers=u(" + from_container + "," + to_container + ");objects=u(" + from_object + "," + to_object + ")";
        readOp.setConfig(readConfig);
        work.addOperation(readOp);
        Operation writeOp = new Operation("write");
        writeOp.setRatio(Integer.parseInt(writeRatio));
        String config = "containers=u(" + from_container + "," + to_container + ");objects=u(" + from_object + "," + to_object + ")";
        writeOp.setConfig(config);
        if (isRange) {
            writeConfig = "containers=u(" + from_container + "," + to_container + ");objects=u(" + from_object + "," + to_object + ");sizes=u" + sizeString;
            writeOp.setConfig(writeConfig);
        } else {
            writeConfig = "containers=u(" + from_container + "," + to_container + ");objects=u(" + from_object + "," + to_object + ");sizes=c" + sizeString;
            writeOp.setConfig(writeConfig);
        }
        work.addOperation(writeOp);
        Operation deleteOp = new Operation("delete");
        deleteOp.setRatio(Integer.parseInt(deleteRatio));
        String deleteConfig = "containers=u(" + from_container + "," + to_container + ");objects=u(" + from_object + "," + to_object + ")";
        deleteOp.setConfig(deleteConfig);
        work.addOperation(deleteOp);
        return stage;
    }

    private Stage createWorkstage(Workflow workflow, String stageName, String stageType, String workers, String config) {
        Stage stage = new Stage(stageName);
        Work work = new Work(stageName, stageType);
        work.setType(stageType);
        work.setWorkers(Integer.parseInt(workers));
        work.setConfig(config);
        stage.addWork(work);
        return stage;
    }
}

