/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.model.StageInfo;
import com.intel.cosbench.model.StageState;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.AbstractController;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

public class StagePageController
extends AbstractController {
    protected ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    protected ModelAndView process(HttpServletRequest req, HttpServletResponse res) {
        String wid = req.getParameter("wid");
        if (StringUtils.isEmpty((String)wid)) {
            throw new BadRequestException();
        }
        String sid = req.getParameter("sid");
        if (StringUtils.isEmpty((String)sid)) {
            throw new BadRequestException();
        }
        return this.process(wid, sid);
    }

    protected ModelAndView process(String wid, String sid) {
        WorkloadInfo wInfo = this.controller.getWorkloadInfo(wid);
        if (wInfo == null) {
            throw new NotFoundException();
        }
        StageInfo sInfo = wInfo.getStageInfo(sid);
        if (sInfo == null) {
            throw new NotFoundException();
        }
        if (this.controller.getloadArch() && sInfo.getSnapshotRegistry().getSize() == 0) {
            try {
                this.controller.getWorkloadLoader().loadStagePageInfo(wInfo, sInfo.getId());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.process(wInfo, sInfo);
    }

    protected ModelAndView process(WorkloadInfo wInfo, StageInfo sInfo) {
        ModelAndView result = new ModelAndView("stage");
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        result.addObject("sInfo", (Object)sInfo);
        result.addObject("wInfo", (Object)wInfo);
        result.addObject("isStopped", (Object)StageState.isStopped((StageState)sInfo.getState()));
        result.addObject("isRunning", (Object)StageState.isRunning((StageState)sInfo.getState()));
        return result;
    }
}

