/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.controller.web.WorkloadPageController;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class DownloadLogController
extends WorkloadPageController {
    private static final View LOG = new LogView();

    @Override
    protected ModelAndView process(WorkloadInfo info) {
        File file = this.controller.getWorkloadLog(info);
        ModelAndView result = new ModelAndView(LOG, "log", (Object)file);
        result.addObject("cInfo", (Object)this.controller.getControllerInfo());
        return result;
    }

    private static class LogView
    implements View {
        private LogView() {
        }

        public String getContentType() {
            return "text/plain";
        }

        public void render(Map<String, ?> model, HttpServletRequest req, HttpServletResponse res) throws Exception {
            File log = (File)model.get("log");
            res.setHeader("Content-Length", String.valueOf(log.length()));
            res.setHeader("Content-Disposition", "attachment; filename=\"workload-log.txt\"");
            FileInputStream input = new FileInputStream(log);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)res.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }
}

