/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.web;

import com.intel.cosbench.controller.web.WorkloadPageController;
import com.intel.cosbench.model.WorkloadInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class DownloadConfigController
extends WorkloadPageController {
    private static final View CONFIG = new ConfigView();

    @Override
    protected ModelAndView process(WorkloadInfo info) {
        File file = this.controller.getWorkloadConfig(info);
        return new ModelAndView(CONFIG, "config", (Object)file);
    }

    private static class ConfigView
    implements View {
        private ConfigView() {
        }

        public String getContentType() {
            return "application/xml";
        }

        public void render(Map<String, ?> model, HttpServletRequest req, HttpServletResponse res) throws Exception {
            File config = (File)model.get("config");
            res.setHeader("Content-Length", String.valueOf(config.length()));
            res.setHeader("Content-Disposition", "attachment; filename=\"workload-config.xml\"");
            FileInputStream input = new FileInputStream(config);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)res.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        }
    }
}

