/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.handler;

import com.intel.cosbench.controller.handler.AbstractClientHandler;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.service.ControllerService;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class WorkloadHandler
extends AbstractClientHandler {
    protected ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    @Override
    protected String process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String id = req.getParameter("id");
        if (StringUtils.isEmpty((String)id)) {
            throw new BadRequestException();
        }
        return this.process(id);
    }

    protected String process(String id) {
        WorkloadInfo info = this.controller.getWorkloadInfo(id);
        if (info == null) {
            throw new NotFoundException();
        }
        return this.process(info);
    }

    protected String process(WorkloadInfo info) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(info.getId()).append('\t').append(info.getSubmitDate()).append('\t').append(info.getState()).append('\n');
        return buffer.toString();
    }
}

