/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.handler;

import com.intel.cosbench.controller.handler.AbstractClientHandler;
import com.intel.cosbench.model.DriverInfo;
import com.intel.cosbench.model.WorkloadInfo;
import com.intel.cosbench.service.ControllerService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IndexHandler
extends AbstractClientHandler {
    private ControllerService controller;

    public void setController(ControllerService controller) {
        this.controller = controller;
    }

    @Override
    protected String process(HttpServletRequest req, HttpServletResponse res) throws Exception {
        StringBuilder buffer = new StringBuilder();
        DriverInfo[] drivers = this.controller.getControllerInfo().getDriverInfos();
        buffer.append("Drivers:").append('\n');
        DriverInfo[] driverInfoArray = drivers;
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            DriverInfo driver = driverInfoArray[n2];
            buffer.append(driver.getName()).append('\t').append(driver.getUrl()).append('\n');
            ++n2;
        }
        buffer.append("Total:").append(' ').append(drivers.length).append(' ').append("drivers").append('\n');
        buffer.append('\n');
        WorkloadInfo[] workloads = this.controller.getActiveWorkloads();
        buffer.append("Active Workloads:").append('\n');
        WorkloadInfo[] workloadInfoArray = workloads;
        int n3 = workloads.length;
        n = 0;
        while (n < n3) {
            WorkloadInfo workload = workloadInfoArray[n];
            buffer.append(workload.getId()).append('\t').append(workload.getSubmitDate()).append('\t').append(workload.getState()).append('\t');
            if (workload.getCurrentStage() != null) {
                buffer.append(workload.getCurrentStage().getId()).append('\n');
            } else {
                buffer.append("None").append('\n');
            }
            ++n;
        }
        buffer.append("Total:").append(' ').append(workloads.length).append(' ').append("active workloads").append('\n');
        return buffer.toString();
    }
}

