/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.controller.handler;

import com.intel.cosbench.config.ConfigException;
import com.intel.cosbench.service.IllegalStateException;
import com.intel.cosbench.web.BadRequestException;
import com.intel.cosbench.web.NotFoundException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.Controller;

abstract class AbstractClientHandler
implements Controller {
    private static View TEXT = new TextView();

    AbstractClientHandler() {
    }

    protected abstract String process(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public ModelAndView handleRequest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String message = null;
        try {
            message = this.process(req, res);
        }
        catch (BadRequestException badRequestException) {
            message = "Bad Request";
        }
        catch (NotFoundException notFoundException) {
            message = "Not Found";
        }
        catch (IllegalStateException ise) {
            message = ise.getMessage();
        }
        catch (ConfigException ce) {
            message = ce.getMessage();
        }
        catch (FileNotFoundException fnfe) {
            message = fnfe.getMessage();
        }
        catch (IOException ie) {
            message = ie.getMessage();
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            message = "Internal Error\n" + writer.toString();
        }
        return new ModelAndView(TEXT, "message", (Object)message);
    }

    private static class TextView
    implements View {
        private TextView() {
        }

        public String getContentType() {
            return "text/plain";
        }

        public void render(Map<String, ?> model, HttpServletRequest req, HttpServletResponse res) throws Exception {
            PrintWriter writer = res.getWriter();
            writer.print(model.get("message"));
        }
    }
}

