/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.cdmi.base;

import com.intel.cosbench.client.cdmi.base.CdmiClientException;
import com.intel.cosbench.client.cdmi.base.CdmiException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public abstract class BaseCdmiClient {
    protected boolean raise_delete_errors = false;
    protected HttpClient client;
    protected HttpContext httpContext;
    protected String uri;
    protected ArrayList<Header> custom_headers = new ArrayList();

    public void init(HttpClient httpClient, String uri, Map<String, String> headerKV, boolean flag) {
        this.client = httpClient;
        this.httpContext = new BasicHttpContext();
        this.httpContext.setAttribute("http.auth.target-scheme-pref", Arrays.asList("Basic", "Digest"));
        BasicAuthCache authCache = new BasicAuthCache();
        this.httpContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        this.uri = uri;
        this.raise_delete_errors = flag;
        for (String key : headerKV.keySet()) {
            this.custom_headers.add((Header)new BasicHeader(key, headerKV.get(key)));
        }
    }

    public abstract void dispose();

    public abstract void createContainer(String var1) throws IOException, CdmiException;

    public abstract void deleteContainer(String var1) throws IOException, CdmiException;

    public abstract InputStream getObjectAsStream(String var1, String var2) throws IOException, CdmiException;

    public abstract void storeStreamedObject(String var1, String var2, InputStream var3, long var4) throws IOException, CdmiClientException;

    public abstract void deleteObject(String var1, String var2) throws IOException, CdmiException;
}

