/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.api.cdmi.base;

import com.intel.cosbench.api.context.AuthContext;
import com.intel.cosbench.api.storage.NoneStorage;
import com.intel.cosbench.api.storage.StorageException;
import com.intel.cosbench.api.storage.StorageInterruptedException;
import com.intel.cosbench.api.storage.StorageTimeoutException;
import com.intel.cosbench.client.cdmi.base.BaseCdmiClient;
import com.intel.cosbench.client.cdmi.base.CdmiClientException;
import com.intel.cosbench.client.cdmi.base.CdmiClientFactory;
import com.intel.cosbench.client.cdmi.base.CdmiConstants;
import com.intel.cosbench.client.http.HttpClientUtil;
import com.intel.cosbench.config.Config;
import com.intel.cosbench.log.Logger;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.apache.http.client.HttpClient;

public class CDMIStorage
extends NoneStorage {
    private HttpClient httpClient;
    private String url;
    private int timeout;
    private String rootPath;
    private String type;
    private String headers;
    private boolean flag;
    private BaseCdmiClient client;
    private String[] header_list;

    public void init(Config config, Logger logger) {
        super.init(config, logger);
        this.initParms(config);
        this.client = CdmiClientFactory.getClient(this.type);
    }

    private void initParms(Config config) {
        this.rootPath = config.get("root_path", "");
        this.timeout = config.getInt("timeout", 30000);
        this.headers = config.get("custom_headers", "");
        this.flag = config.getBoolean("raise_delete_errors", CdmiConstants.RAISE_DELETE_ERRORS_DEFAULT.booleanValue());
        this.type = config.get("type", "cdmi");
        this.header_list = this.headers.split(",");
        this.parms.put("root_path", (Object)this.rootPath);
        this.parms.put("timeout", (Object)this.timeout);
        this.parms.put("raise_delete_errors", (Object)this.flag);
        this.parms.put("type", (Object)this.type);
    }

    public void setAuthContext(AuthContext info) {
        super.setAuthContext(info);
        try {
            this.httpClient = (HttpClient)info.get("client");
            if (this.httpClient == null) {
                this.httpClient = HttpClientUtil.createHttpClient((int)this.timeout);
            }
            this.url = String.valueOf(info.getStr("storage_url")) + this.rootPath;
            HashMap<String, String> headerKV = new HashMap<String, String>();
            String[] stringArray = this.header_list;
            int n = this.header_list.length;
            int n2 = 0;
            while (n2 < n) {
                String header = stringArray[n2];
                String[] kv = header.split(":");
                if (kv.length >= 2) {
                    headerKV.put(kv[0], info.getStr(kv[1]));
                }
                ++n2;
            }
            this.logger.debug("httpclient =" + this.httpClient + ", url = " + this.url);
            this.client.init(this.httpClient, this.url, headerKV, false);
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void dispose() {
        super.dispose();
        this.client.dispose();
    }

    public InputStream getObject(String container, String object, Config config) {
        InputStream stream;
        super.getObject(container, object, config);
        try {
            stream = this.client.getObjectAsStream(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
        return stream;
    }

    public void createContainer(String container, Config config) {
        super.createContainer(container, config);
        try {
            this.client.createContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void createObject(String container, String object, InputStream data, long length, Config config) {
        super.createObject(container, object, data, length, config);
        try {
            this.client.storeStreamedObject(container, object, data, length);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteContainer(String container, Config config) {
        super.deleteContainer(container, config);
        try {
            this.client.deleteContainer(container);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void deleteObject(String container, String object, Config config) {
        super.deleteObject(container, object, config);
        try {
            this.client.deleteObject(container, object);
        }
        catch (SocketTimeoutException te) {
            throw new StorageTimeoutException((Throwable)te);
        }
        catch (InterruptedIOException ie) {
            throw new StorageInterruptedException((Throwable)ie);
        }
        catch (CdmiClientException se) {
            String msg = se.getHttpStatusLine().toString();
            throw new StorageException(msg, (Throwable)((Object)se));
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }
}

