/*
 * Decompiled with CFR 0.152.
 */
package com.intel.cosbench.client.swauth.utils;

import com.intel.cosbench.api.auth.AuthException;
import com.intel.cosbench.api.auth.AuthInterruptedException;
import com.intel.cosbench.api.auth.AuthTimeoutException;
import com.intel.cosbench.client.swauth.SwiftAuthClient;
import com.intel.cosbench.client.swauth.SwiftAuthClientException;
import com.intel.cosbench.client.swauth.utils.SwiftTokenCache;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;

public class SwiftTokenCacheImpl {
    private static SwiftTokenCache latestTokenCache = new SwiftTokenCache();

    public static synchronized void loadSwiftTokenCache(SwiftAuthClient client, SwiftTokenCache currentTokenCache) {
        if (currentTokenCache.getVersion() == latestTokenCache.getVersion()) {
            try {
                client.login();
                latestTokenCache.setToken(client.getAuthToken());
                latestTokenCache.setStorageURL(client.getStorageURL());
                latestTokenCache.incrementVersion();
            }
            catch (SocketTimeoutException ste) {
                throw new AuthTimeoutException((Throwable)ste);
            }
            catch (ConnectTimeoutException cte) {
                throw new AuthTimeoutException((Throwable)cte);
            }
            catch (InterruptedIOException ie) {
                throw new AuthInterruptedException((Throwable)ie);
            }
            catch (SwiftAuthClientException se) {
                throw new AuthException(se.getMessage(), (Throwable)((Object)se));
            }
            catch (Exception e) {
                throw new AuthException((Throwable)e);
            }
        }
    }

    public static SwiftTokenCache getSwiftTokenCache(SwiftAuthClient client) {
        if (latestTokenCache.getVersion() == 0L || !client.check()) {
            SwiftTokenCacheImpl.loadSwiftTokenCache(client, latestTokenCache);
        }
        return latestTokenCache;
    }
}

